/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.impl;

import com.adobe.acs.commons.quickly.QuicklyEngine;
import com.adobe.acs.commons.util.BufferingResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Component(policy=ConfigurationPolicy.OPTIONAL)
@Properties(value={@Property(name="osgi.http.whiteboard.filter.pattern", value={"/"}), @Property(name="osgi.http.whiteboard.context.select", value={"(osgi.http.whiteboard.context.name=*)"})})
@Service
public class QuicklyFilter
implements Filter {
    private static final String[] REJECT_PATH_PREFIXES = new String[]{"/libs/granite/core/content/login"};
    private static final String HTML_FILE = "/quickly/inject.html";
    private String appHTML = "";
    @Reference
    private QuicklyEngine quicklyEngine;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        int bodyIndex;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.accepts(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BufferingResponse capturedResponse = new BufferingResponse(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)capturedResponse);
        String contents = capturedResponse.getContents();
        if (contents != null && StringUtils.contains((String)response.getContentType(), (String)"html") && (bodyIndex = contents.indexOf("</body>")) != -1) {
            PrintWriter printWriter = response.getWriter();
            printWriter.write(contents.substring(0, bodyIndex));
            printWriter.write(this.appHTML);
            printWriter.write(contents.substring(bodyIndex));
            return;
        }
        if (contents != null) {
            response.getWriter().write(contents);
        }
    }

    public void destroy() {
    }

    private boolean accepts(HttpServletRequest request) {
        if (!StringUtils.equalsIgnoreCase((String)"get", (String)request.getMethod())) {
            return false;
        }
        if (StringUtils.startsWithAny((String)request.getRequestURI(), (String[])REJECT_PATH_PREFIXES)) {
            return false;
        }
        if (StringUtils.equals((String)request.getHeader("X-Requested-With"), (String)"XMLHttpRequest")) {
            return false;
        }
        if (StringUtils.endsWith((String)request.getHeader("Referer"), (String)("/editor.html" + request.getRequestURI()))) {
            return false;
        }
        return !StringUtils.endsWith((String)request.getHeader("Referer"), (String)"/cf");
    }

    @Activate
    protected final void activate(Map<String, String> config) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(HTML_FILE);
            this.appHTML = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    protected void bindQuicklyEngine(QuicklyEngine quicklyEngine) {
        this.quicklyEngine = quicklyEngine;
    }

    protected void unbindQuicklyEngine(QuicklyEngine quicklyEngine) {
        if (this.quicklyEngine == quicklyEngine) {
            this.quicklyEngine = null;
        }
    }
}

