/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.results;

import java.util.HashMap;
import java.util.Map;

public class Action {
    private String uri;
    private Method method;
    private Map<String, String> params;
    private String script;
    private Target target;

    private Action(Builder builder) {
        this.setMethod(builder.method);
        this.setParams(builder.params);
        this.setScript(builder.script);
        this.setTarget(builder.target);
        this.setUri(builder.uri);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params == null ? new HashMap<String, String>() : params;
    }

    public static class Builder {
        private Method method = Method.GET;
        private Map<String, String> params;
        private String script;
        private Target target = Target.SELF;
        private String uri = "#";

        public Action build() {
            return new Action(this);
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder target(Target target) {
            this.target = target;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder script(String script) {
            this.script = script;
            this.method = Method.JS;
            return this;
        }
    }

    public static enum Method {
        GET("get"),
        POST("post"),
        NOOP("noop"),
        JS("js"),
        CMD("cmd");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Target {
        BLANK("_blank"),
        TOP("_top"),
        SELF("_self");

        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

