/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.results;

import com.adobe.acs.commons.quickly.results.Action;
import com.day.cq.wcm.api.AuthoringUIMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class Result {
    private Action action;
    private AuthoringUIMode authoringMode;
    private String description;
    private List<Mode> modes;
    private String path;
    private String resultType;
    private Action secondaryAction;
    private String title;

    private Result(Builder builder) {
        this.setResultType(builder.resultType);
        this.setTitle(builder.title);
        this.setDescription(builder.description);
        this.setPath(builder.path);
        this.setAction(builder.action);
        this.setSecondaryAction(builder.secondaryAction);
        this.setAuthoringMode(builder.authoringMode);
        this.setModes(builder.modes);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action == null ? new Action.Builder().build() : action;
    }

    public AuthoringUIMode getAuthoringMode() {
        return this.authoringMode;
    }

    public void setAuthoringMode(AuthoringUIMode authoringMode) {
        this.authoringMode = authoringMode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Mode> getModes() {
        return this.modes;
    }

    public void setModes(List<Mode> modes) {
        if (this.modes == null) {
            this.modes = new ArrayList<Mode>();
        }
        if (modes == null || CollectionUtils.isEmpty(modes)) {
            this.modes.add(Mode.ANY);
        } else {
            this.modes = modes;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getResultType() {
        return StringUtils.upperCase((String)this.resultType);
    }

    public void setResultType(String resultType) {
        this.resultType = StringUtils.upperCase((String)resultType);
    }

    public Action getSecondaryAction() {
        return this.secondaryAction;
    }

    public void setSecondaryAction(Action secondaryAction) {
        this.secondaryAction = secondaryAction == null ? new Action.Builder().build() : secondaryAction;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static class Builder {
        private Action action;
        private AuthoringUIMode authoringMode = null;
        private String description;
        private List<Mode> modes = new ArrayList<Mode>();
        private String path;
        private String resultType;
        private Action secondaryAction;
        private String title;

        public Builder(String title) {
            this.title = title;
        }

        public Result build() {
            return new Result(this);
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder secondaryAction(Action secondaryAction) {
            this.secondaryAction = secondaryAction;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder classic() {
            this.authoringMode = AuthoringUIMode.CLASSIC;
            return this;
        }

        public Builder touch() {
            this.authoringMode = AuthoringUIMode.TOUCH;
            return this;
        }

        public Builder dev() {
            this.modes.add(Mode.DEV);
            return this;
        }
    }

    public static enum Mode {
        DEV("dev"),
        ANY("any");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

