/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.models;

import com.adobe.acs.commons.redirectmaps.models.RedirectMapModel;
import org.apache.sling.api.resource.Resource;

public class MapEntry {
    private final Resource resource;
    private final String source;
    private final String target;
    private final boolean valid;

    public MapEntry(Resource resource, String source, String target) {
        source = source.trim();
        if (source.matches(".*\\s.*")) {
            RedirectMapModel.log.warn("Source path {} for content {} contains whitespace", (Object)source, (Object)resource);
            this.valid = false;
        } else {
            this.valid = true;
        }
        this.source = source;
        this.target = target;
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "MapEntry [resource=" + this.resource + ", source=" + this.source + ", target=" + this.target + ", valid=" + this.valid + "]";
    }
}

