/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.models;

import com.adobe.acs.commons.redirectmaps.impl.FakeSlingHttpServletRequest;
import com.adobe.acs.commons.redirectmaps.models.MapEntry;
import com.adobe.acs.commons.redirectmaps.models.RedirectConfigModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class RedirectMapModel {
    static final Logger log = LoggerFactory.getLogger(RedirectMapModel.class);
    @Inject
    @Optional
    @Named(value="redirectMap.txt")
    private Resource redirectMap;
    @Inject
    @Optional
    private List<RedirectConfigModel> redirects;
    @Inject
    @Source(value="sling-object")
    private ResourceResolver resourceResolver;

    private List<MapEntry> addItems(RedirectConfigModel config, Iterator<Resource> items, StringBuilder sb, String suffix) {
        ArrayList<MapEntry> invalidEntries = new ArrayList<MapEntry>();
        while (items.hasNext()) {
            String[] sources;
            Resource item = items.next();
            String path = item.getPath();
            ValueMap properties = item.getChild("jcr:content").getValueMap();
            FakeSlingHttpServletRequest mockRequest = new FakeSlingHttpServletRequest(this.resourceResolver, config.getProtocol(), config.getDomain(), config.getProtocol().equals("https") ? 443 : 80);
            String pageUrl = config.getProtocol() + "://" + config.getDomain() + this.resourceResolver.map((HttpServletRequest)mockRequest, item.getPath() + suffix);
            for (String source : sources = (String[])properties.get(config.getProperty(), String[].class)) {
                MapEntry entry = new MapEntry(item, source, pageUrl);
                if (!entry.isValid()) {
                    log.warn("Source path {} for content {} contains whitespace", (Object)entry.getSource(), (Object)path);
                    invalidEntries.add(entry);
                    continue;
                }
                sb.append(entry.getSource() + " " + entry.getTarget() + "\n");
            }
        }
        return invalidEntries;
    }

    private List<MapEntry> gatherEntries(RedirectConfigModel config, StringBuilder sb) {
        log.trace("gatherEntries");
        log.debug("Getting all of the entries for {}", (Object)config.getResource());
        ArrayList<MapEntry> invalidEntries = new ArrayList<MapEntry>();
        sb.append("\n# Dynamic entries for " + config.getResource().getPath() + "\n");
        String pageQuery = "SELECT * FROM [cq:Page] WHERE [jcr:content/" + config.getProperty() + "] IS NOT NULL AND (ISDESCENDANTNODE([" + config.getPath() + "]) OR [jcr:path]='" + config.getPath() + "')";
        log.debug("Finding pages with redirects with query: {}", (Object)pageQuery);
        invalidEntries.addAll(this.addItems(config, this.resourceResolver.findResources(pageQuery, "JCR-SQL2"), sb, ".html"));
        String assetQuery = "SELECT * FROM [dam:Asset] WHERE [jcr:content/" + config.getProperty() + "] IS NOT NULL AND (ISDESCENDANTNODE([" + config.getPath() + "]) OR [jcr:path]='" + config.getPath() + "')";
        log.debug("Finding assets with redirects with query: {}", (Object)assetQuery);
        invalidEntries.addAll(this.addItems(config, this.resourceResolver.findResources(assetQuery, "JCR-SQL2"), sb, ""));
        return invalidEntries;
    }

    public List<MapEntry> getInvalidEntries() {
        log.trace("getInvalidEntries");
        ArrayList<MapEntry> invalidEntries = new ArrayList<MapEntry>();
        StringBuilder sb = new StringBuilder();
        if (this.redirects != null) {
            for (RedirectConfigModel config : this.redirects) {
                invalidEntries.addAll(this.gatherEntries(config, sb));
            }
        }
        log.debug("Found {} invalid entries", (Object)invalidEntries.size());
        return invalidEntries;
    }

    public String getRedirectMap() throws IOException {
        log.debug("Retrieving redirect map from {}", (Object)this.redirectMap);
        StringBuilder sb = new StringBuilder();
        if (this.redirectMap != null) {
            log.debug("Loading RedirectMap file from {}", (Object)this.redirectMap);
            sb.append("# Redirect Map File\n");
            InputStream is = (InputStream)this.redirectMap.adaptTo(InputStream.class);
            sb.append(IOUtils.toString((InputStream)is));
        } else {
            log.debug("No redirect map specified");
        }
        if (this.redirects != null) {
            for (RedirectConfigModel config : this.redirects) {
                this.gatherEntries(config, sb);
            }
        } else {
            log.debug("No redirect configurations specified");
        }
        return sb.toString();
    }
}

