/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrandPortalAgentFilter
implements AgentFilter {
    private static final Logger log = LoggerFactory.getLogger(BrandPortalAgentFilter.class);
    private final List<Resource> brandPortalConfigs;
    private static final String PROP_MP_CONFIG = "mpConfig";
    private static final String PROP_TENTANT_URL = "tenantURL";

    public BrandPortalAgentFilter(Resource content) {
        this.brandPortalConfigs = this.getBrandPortalConfigs(content);
    }

    public boolean isIncluded(Agent agent) {
        String transportURI = agent.getConfiguration().getTransportURI();
        for (Resource config : this.brandPortalConfigs) {
            boolean included;
            ValueMap properties;
            String tenantUrl;
            if (log.isDebugEnabled()) {
                log.debug("Checking Agent [ {} ] against Brand Portal cloud service config [ {} ] for property [ {} ]", (Object[])new String[]{agent.getId(), config.getPath(), PROP_TENTANT_URL});
            }
            if (!StringUtils.isNotBlank((String)(tenantUrl = StringUtils.stripToNull((String)((String)(properties = config.getValueMap()).get(PROP_TENTANT_URL, String.class))))) || !(included = StringUtils.startsWith((String)transportURI, (String)(tenantUrl + "/")))) continue;
            log.debug("Including replication agent [ {} ]", (Object)agent.getId());
            return true;
        }
        return false;
    }

    protected List<Resource> getBrandPortalConfigs(Resource content) {
        if (content == null) {
            return Collections.emptyList();
        }
        if ("jcr:content".equals(content.getName())) {
            content = content.getParent();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ResourceResolver resourceResolver = content.getResourceResolver();
        do {
            ValueMap properties;
            Object[] configs;
            if (ArrayUtils.isNotEmpty((Object[])(configs = (String[])(properties = content.getValueMap()).get(PROP_MP_CONFIG, (Object)new String[0])))) {
                if (log.isDebugEnabled()) {
                    log.debug("Resolved Brand Portal configs [ {}@{} -> {} ]", (Object[])new String[]{content.getPath(), PROP_MP_CONFIG, StringUtils.join((Object[])configs, (String)",")});
                }
                for (Object config : configs) {
                    Resource r = resourceResolver.getResource((String)config + "/" + "jcr:content");
                    if (r == null) continue;
                    resources.add(r);
                }
                break;
            }
            if (content.getParent() == null) continue;
            content = content.getParent();
        } while (content != null);
        return resources;
    }
}

