/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.replication.dispatcher.DispatcherFlushFilter;
import com.adobe.acs.commons.replication.dispatcher.DispatcherFlusher;
import com.adobe.acs.commons.replication.dispatcher.impl.ReplicationResultListener;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationListener;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.replication.Replicator;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class DispatcherFlusherImpl
implements DispatcherFlusher {
    private static final Logger log = LoggerFactory.getLogger(DispatcherFlusherImpl.class);
    @Reference
    private Replicator replicator;
    @Reference
    private AgentManager agentManager;

    @Override
    public final Map<Agent, ReplicationResult> flush(ResourceResolver resourceResolver, String ... paths) throws ReplicationException {
        return this.flush(resourceResolver, ReplicationActionType.ACTIVATE, false, paths);
    }

    @Override
    public final Map<Agent, ReplicationResult> flush(ResourceResolver resourceResolver, ReplicationActionType actionType, boolean synchronous, String ... paths) throws ReplicationException {
        return this.flush(resourceResolver, actionType, synchronous, DispatcherFlushFilter.HIERARCHICAL, paths);
    }

    @Override
    public final Map<Agent, ReplicationResult> flush(ResourceResolver resourceResolver, ReplicationActionType actionType, boolean synchronous, AgentFilter agentFilter, String ... paths) throws ReplicationException {
        ReplicationOptions options = new ReplicationOptions();
        ReplicationResultListener listener = new ReplicationResultListener();
        options.setFilter(agentFilter);
        options.setSynchronous(synchronous);
        options.setSuppressStatusUpdate(true);
        options.setSuppressVersions(true);
        options.setListener((ReplicationListener)listener);
        for (String path : paths) {
            if (log.isDebugEnabled()) {
                log.debug("--------------------------------------------------------------------------------");
                log.debug("Issuing Dispatcher Flush (via AEM Replication API) request for: {}", (Object)path);
                log.debug(" > Synchronous: {}", (Object)options.isSynchronous());
                log.debug(" > Replication Action Type: {}", (Object)actionType.name());
            }
            this.replicator.replicate((Session)resourceResolver.adaptTo(Session.class), actionType, path, options);
        }
        return listener.getResults();
    }

    @Override
    public final Agent[] getFlushAgents() {
        return this.getAgents(new DispatcherFlushFilter());
    }

    @Override
    public final Agent[] getAgents(AgentFilter agentFilter) {
        ArrayList<Agent> flushAgents = new ArrayList<Agent>();
        for (Agent agent : this.agentManager.getAgents().values()) {
            if (!agentFilter.isIncluded(agent)) continue;
            flushAgents.add(agent);
        }
        return flushAgents.toArray(new Agent[flushAgents.size()]);
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    protected void unbindAgentManager(AgentManager agentManager) {
        if (this.agentManager == agentManager) {
            this.agentManager = null;
        }
    }
}

