/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class TagsCellValue {
    private static final Logger log = LoggerFactory.getLogger(TagsCellValue.class);
    @Self
    private SlingHttpServletRequest request;
    @ValueMapValue
    private String property;

    public List<Tag> getTags() {
        TagManager tagMgr = (TagManager)this.request.getResourceResolver().adaptTo(TagManager.class);
        Resource resource = (Resource)this.request.getAttribute("result");
        log.debug("Loading tags from {}@{}", (Object[])new String[]{resource.getPath(), this.property});
        ArrayList<Tag> tags = new ArrayList<Tag>();
        String[] values = (String[])resource.getValueMap().get(this.property, String[].class);
        if (values != null) {
            for (String value : values) {
                tags.add(tagMgr.resolve(value));
            }
        }
        log.debug("Loaded {} tags", (Object)tags.size());
        return tags;
    }
}

