/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.AbstractTransformer;
import com.adobe.acs.commons.rewriter.impl.SaxElementUtils;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(metatype=true, label="Stylesheet Inliner Transformer Factory", description="Sling Rewriter Transformer Factory which inlines CSS references")
@Properties(value={@Property(name="pipeline.type", value={"inline-css"}, propertyPrivate=true)})
@Service(value={TransformerFactory.class})
public final class StylesheetInlinerTransformerFactory
implements TransformerFactory {
    private static final char[] NEWLINE = new char[]{'\n'};
    private static final String STYLE = "style";
    private static final String HEAD = "head";
    private static final Logger log = LoggerFactory.getLogger(StylesheetInlinerTransformerFactory.class);
    @Reference
    private HtmlLibraryManager htmlLibraryManager;

    public Transformer createTransformer() {
        return new CssInlinerTransformer();
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    private class CssInlinerTransformer
    extends AbstractTransformer {
        protected boolean afterHeadElement = false;
        protected List<String> stylesheetsInHead = new ArrayList<String>();
        private SlingHttpServletRequest slingRequest;

        private CssInlinerTransformer() {
        }

        @Override
        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
            super.init(context, config);
            this.slingRequest = context.getRequest();
            log.debug("Inlining Stylesheet references for {}", (Object)this.slingRequest.getRequestURL().toString());
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            try {
                if (SaxElementUtils.isCss(localName, attrs)) {
                    String sheet = attrs.getValue("", "href");
                    if (!this.afterHeadElement) {
                        this.stylesheetsInHead.add(sheet);
                    } else {
                        log.debug("Inlining stylesheet link found in BODY: '{}'", (Object)sheet);
                        this.inlineSheet(namespaceURI, sheet);
                    }
                } else {
                    this.getContentHandler().startElement(namespaceURI, localName, qName, attrs);
                }
            }
            catch (Exception e) {
                log.error("Exception in stylesheet inliner", (Throwable)e);
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase(StylesheetInlinerTransformerFactory.HEAD)) {
                this.afterHeadElement = true;
                try {
                    for (String sheet : this.stylesheetsInHead) {
                        log.debug("Inlining sheet found in HEAD: '{}'", (Object)sheet);
                        this.inlineSheet(uri, sheet);
                    }
                }
                catch (Exception e) {
                    log.error("Exception in stylesheet inliner", (Throwable)e);
                    throw new SAXException(e);
                }
            }
            this.getContentHandler().endElement(uri, localName, qName);
        }

        private void inlineSheet(String namespaceURI, String s) throws IOException, SAXException {
            InputStream inputStream = null;
            String withoutExtension = s.substring(0, s.indexOf(LibraryType.CSS.extension));
            HtmlLibrary library = StylesheetInlinerTransformerFactory.this.htmlLibraryManager.getLibrary(LibraryType.CSS, withoutExtension);
            if (library != null) {
                inputStream = library.getInputStream();
            } else {
                Resource resource = this.slingRequest.getResourceResolver().getResource(s);
                if (resource != null) {
                    inputStream = (InputStream)resource.adaptTo(InputStream.class);
                }
            }
            if (inputStream != null) {
                char[] chars = IOUtils.toCharArray((InputStream)inputStream);
                this.getContentHandler().startElement(namespaceURI, StylesheetInlinerTransformerFactory.STYLE, null, new AttributesImpl());
                this.getContentHandler().characters(NEWLINE, 0, 1);
                this.getContentHandler().characters(chars, 0, chars.length);
                this.getContentHandler().endElement(namespaceURI, StylesheetInlinerTransformerFactory.STYLE, null);
            }
        }
    }
}

