/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.Ace;
import com.adobe.acs.commons.users.impl.EnsureServiceUserException;
import com.adobe.acs.commons.users.impl.ServiceUser;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Ensure Service User", configurationFactory=true, metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Ensure Service User: {operation} {principalName}"})})
@Service(value={EnsureServiceUser.class})
public final class EnsureServiceUser {
    private static final Logger log = LoggerFactory.getLogger(EnsureServiceUser.class);
    private static final String SERVICE_NAME = "ensure-service-user";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "ensure-service-user");
    private ServiceUser serviceUser = null;
    private Operation operation = null;
    public static boolean DEFAULT_ENSURE_IMMEDIATELY = true;
    @Property(label="Ensure immediately", boolValue={true}, description="Ensure on activation. When set to false, this must be ensured via the JMX MBean.")
    public static final String PROP_ENSURE_IMMEDIATELY = "ensure-immediately";
    public static final String DEFAULT_OPERATION = "add";
    @Property(label="Operation", description="Defines if the service user (principal name) should be adjusted to align with this config or removed completely", options={@PropertyOption(name="add", value="Ensure existence (add)"), @PropertyOption(name="remove", value="Ensure extinction (remove)")})
    public static final String PROP_OPERATION = "operation";
    @Property(label="Principal Name", description="The service user's principal name")
    public static final String PROP_PRINCIPAL_NAME = "principalName";
    @Property(label="ACEs", description="This field is ignored if the Operation is set to 'Ensure extinction' (remove)", cardinality=0x7FFFFFFF)
    public static final String PROP_ACES = "aces";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private QueryBuilder queryBuilder;

    public ServiceUser getServiceUser() {
        return this.serviceUser;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void ensure(Operation operation, ServiceUser serviceUser) throws EnsureServiceUserException {
        long start = System.currentTimeMillis();
        try (ResourceResolver resourceResolver = null;){
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
            if (Operation.ADD.equals((Object)operation)) {
                this.ensureExistance(resourceResolver, serviceUser);
            } else if (Operation.REMOVE.equals((Object)operation)) {
                this.ensureRemoval(resourceResolver, serviceUser);
            } else {
                throw new EnsureServiceUserException("Unable to determine Ensure Service User operation Could not create or locate value system user (it is null).");
            }
            if (resourceResolver.hasChanges()) {
                resourceResolver.commit();
                log.debug("Persisted change to Service User [ {} ]", (Object)serviceUser.getPrincipalName());
            } else {
                log.debug("No changes required for Service User [ {} ]. Skipping...", (Object)serviceUser.getPrincipalName());
            }
            log.info("Successfully ensured [ {} ] of Service User [ {} ] in [ {} ms ]", (Object[])new String[]{operation.toString(), this.getServiceUser().getPrincipalName(), String.valueOf(System.currentTimeMillis() - start)});
        }
    }

    protected void ensureExistance(ResourceResolver resourceResolver, ServiceUser serviceUser) throws RepositoryException, EnsureServiceUserException {
        User systemUser = this.ensureSystemUser(resourceResolver, serviceUser);
        if (systemUser != null) {
            this.ensureAces(resourceResolver, systemUser, serviceUser);
        } else {
            log.error("Could not create or locate System User with principal name [ {} ]", (Object)serviceUser.getPrincipalName());
        }
    }

    private void ensureRemoval(ResourceResolver resourceResolver, ServiceUser serviceUser) throws RepositoryException, EnsureServiceUserException {
        User systemUser = this.findSystemUser(resourceResolver, serviceUser.getPrincipalName());
        this.removeAces(resourceResolver, systemUser, serviceUser);
        if (systemUser != null) {
            systemUser.remove();
        }
    }

    private User ensureSystemUser(ResourceResolver resourceResolver, ServiceUser serviceUser) throws RepositoryException, EnsureServiceUserException {
        User user = this.findSystemUser(resourceResolver, serviceUser.getPrincipalName());
        if (user == null) {
            UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
            log.debug("Requesting creation of system user [ {} ] at [ {} ]", (Object)serviceUser.getPrincipalName(), (Object)serviceUser.getIntermediatePath());
            user = userManager.createSystemUser(serviceUser.getPrincipalName(), serviceUser.getIntermediatePath());
            log.debug("Created system user at [ {} ]", (Object)user.getPath());
        }
        return user;
    }

    private int ensureAces(ResourceResolver resourceResolver, User systemUser, ServiceUser serviceUser) throws RepositoryException {
        int failures = 0;
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        JackrabbitAccessControlManager accessControlManager = (JackrabbitAccessControlManager)session.getAccessControlManager();
        List<JackrabbitAccessControlList> acls = this.findAcls(resourceResolver, serviceUser.getPrincipalName(), accessControlManager);
        for (JackrabbitAccessControlList acl : acls) {
            JackrabbitAccessControlEntry[] aces = (JackrabbitAccessControlEntry[])acl.getAccessControlEntries();
            boolean serviceUserCoversThisPath = serviceUser.hasAceAt(acl.getPath());
            for (JackrabbitAccessControlEntry ace : aces) {
                if (!StringUtils.equals((String)serviceUser.getPrincipalName(), (String)ace.getPrincipal().getName()) || StringUtils.startsWith((String)acl.getPath(), (String)systemUser.getPath())) continue;
                if (!serviceUserCoversThisPath) {
                    log.debug("Service user does NOT cover the path yet has an ACE; ensure removal of the ace! {}", (Object)ace.toString());
                    acl.removeAccessControlEntry((AccessControlEntry)ace);
                    continue;
                }
                Ace serviceUserAce = serviceUser.getAce(ace);
                if (serviceUserAce == null) {
                    acl.removeAccessControlEntry((AccessControlEntry)ace);
                    log.debug("Removed System ACE as it doesn't exist in Service User [ {} ] configuration", (Object)serviceUser.getPrincipalName());
                    continue;
                }
                serviceUserAce.setExists(true);
                log.debug("No-op on System ACE as it already matches Service User [ {} ] configuration", (Object)serviceUser.getPrincipalName());
            }
            accessControlManager.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        }
        for (Ace ace : serviceUser.getMissingAces()) {
            if (resourceResolver.getResource(ace.getContentPath()) == null) {
                log.warn("Unable to apply Service User [ {} ] privileges due to missing path at [ {} ]. Please create the path and re-ensure this service user.", (Object)serviceUser.getPrincipalName(), (Object)ace.getContentPath());
                ++failures;
                continue;
            }
            JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((Session)session, (String)ace.getContentPath());
            HashMap<String, Value> restrictions = new HashMap<String, Value>();
            HashMap<String, Value[]> multiRestrictions = new HashMap<String, Value[]>();
            ValueFactory valueFactory = session.getValueFactory();
            if (ace.hasRepGlob()) {
                restrictions.put("rep:glob", valueFactory.createValue(ace.getRepGlob(), 1));
            }
            if (ace.hasRepNtNames()) {
                multiRestrictions.put("rep:ntNames", this.getMultiValues(valueFactory, ace.getRepNtNames(), 7));
            }
            if (ace.hasRepItemNames()) {
                multiRestrictions.put("rep:itemNames", this.getMultiValues(valueFactory, ace.getRepItemNames(), 7));
            }
            if (ace.hasRepPrefixes()) {
                multiRestrictions.put("rep:prefixes", this.getMultiValues(valueFactory, ace.getRepPrefixes(), 1));
            }
            acl.addEntry(systemUser.getPrincipal(), ace.getPrivileges((AccessControlManager)accessControlManager).toArray(new Privilege[0]), ace.isAllow(), restrictions, multiRestrictions);
            accessControlManager.setPolicy(ace.getContentPath(), (AccessControlPolicy)acl);
            log.debug("Added Service User ACE for [ {} ] to [ {} ]", (Object)serviceUser.getPrincipalName(), (Object)ace.getContentPath());
        }
        return failures;
    }

    private void removeAces(ResourceResolver resourceResolver, User systemUser, ServiceUser serviceUser) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        JackrabbitAccessControlManager accessControlManager = (JackrabbitAccessControlManager)session.getAccessControlManager();
        List<JackrabbitAccessControlList> acls = this.findAcls(resourceResolver, serviceUser.getPrincipalName(), accessControlManager);
        for (JackrabbitAccessControlList acl : acls) {
            JackrabbitAccessControlEntry[] aces;
            for (JackrabbitAccessControlEntry ace : aces = (JackrabbitAccessControlEntry[])acl.getAccessControlEntries()) {
                if (!StringUtils.equals((String)serviceUser.getPrincipalName(), (String)ace.getPrincipal().getName()) || systemUser != null && StringUtils.startsWith((String)acl.getPath(), (String)systemUser.getPath())) continue;
                acl.removeAccessControlEntry((AccessControlEntry)ace);
            }
            accessControlManager.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
            log.debug("Removed ACE from ACL at [ {} ] for [ {} ]", (Object)acl.getPath(), (Object)serviceUser.getPrincipalName());
        }
    }

    private User findSystemUser(ResourceResolver resourceResolver, String principalName) throws RepositoryException, EnsureServiceUserException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        User user = null;
        Authorizable authorizable = userManager.getAuthorizable(principalName);
        if (authorizable != null) {
            if (authorizable instanceof User) {
                user = (User)authorizable;
                if (!user.isSystemUser()) {
                    throw new EnsureServiceUserException(String.format("User [ %s ] ensureExistance at [ %s ] but is NOT a system user", principalName, user.getPath()));
                }
            } else {
                throw new EnsureServiceUserException(String.format("Authorizable [ %s ] at [ %s ] is not a user", principalName, authorizable.getPath()));
            }
        }
        return user;
    }

    private List<JackrabbitAccessControlList> findAcls(ResourceResolver resourceResolver, String principalName, JackrabbitAccessControlManager accessControlManager) throws RepositoryException {
        HashSet paths = new HashSet();
        ArrayList<JackrabbitAccessControlList> acls = new ArrayList<JackrabbitAccessControlList>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "rep:ACE");
        params.put("property", "rep:principalName");
        params.put("property.value", principalName);
        params.put("p.limit", "-1");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(params), (Session)resourceResolver.adaptTo(Session.class));
        Iterator resources = query.getResult().getResources();
        block0: while (resources.hasNext()) {
            Resource contentResource = ((Resource)resources.next()).getParent().getParent();
            if (paths.contains(contentResource.getPath())) continue;
            for (AccessControlPolicy policy : accessControlManager.getPolicies(contentResource.getPath())) {
                if (!(policy instanceof JackrabbitAccessControlList)) continue;
                acls.add((JackrabbitAccessControlList)policy);
                continue block0;
            }
        }
        return acls;
    }

    private Value[] getMultiValues(ValueFactory valueFactory, List<String> valueStrs, int propertyType) throws ValueFormatException {
        ArrayList<Value> result = new ArrayList<Value>();
        for (String valueStr : valueStrs) {
            result.add(valueFactory.createValue(valueStr, propertyType));
        }
        return result.toArray(new Value[result.size()]);
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        boolean ensureImmediately = PropertiesUtil.toBoolean((Object)config.get(PROP_ENSURE_IMMEDIATELY), (boolean)DEFAULT_ENSURE_IMMEDIATELY);
        String operationStr = StringUtils.upperCase((String)PropertiesUtil.toString((Object)config.get(PROP_OPERATION), (String)DEFAULT_OPERATION));
        try {
            this.operation = Operation.valueOf(operationStr);
            this.serviceUser = new ServiceUser(config);
            if (ensureImmediately) {
                this.ensure(this.operation, this.getServiceUser());
            } else {
                log.info("This Service User is configured to NOT ensure immediately. Please ensure this Service User via the JMX MBean.");
            }
        }
        catch (EnsureServiceUserException e) {
            log.error("Unable to ensure Service User [ {} ]", (Object)PropertiesUtil.toString((Object)config.get(PROP_PRINCIPAL_NAME), (String)"Undefined Service User Principal Name"), (Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown Ensure Service User operation [ " + operationStr + " ]", e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }
}

