/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.EnsureServiceUser;
import com.adobe.acs.commons.users.impl.EnsureServiceUserException;
import com.adobe.acs.commons.users.impl.EnsureServiceUserManager;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(label="MBean Name", name="jmx.objectname", value={"com.adobe.acs.commons:type=Ensure Service User"}, propertyPrivate=true)})
@References(value={@Reference(referenceInterface=EnsureServiceUser.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)})
@Service(value={DynamicMBean.class})
public class EnsureServiceUserManagerImpl
extends AnnotatedStandardMBean
implements EnsureServiceUserManager {
    private final Logger log = LoggerFactory.getLogger(EnsureServiceUserManagerImpl.class);
    private Map<String, EnsureServiceUser> ensureServiceUsers = new ConcurrentHashMap<String, EnsureServiceUser>();

    public EnsureServiceUserManagerImpl() throws NotCompliantMBeanException {
        super(EnsureServiceUserManager.class);
    }

    @Override
    public final void ensureAll() {
        for (EnsureServiceUser ensureServiceUser : this.ensureServiceUsers.values()) {
            try {
                ensureServiceUser.ensure(ensureServiceUser.getOperation(), ensureServiceUser.getServiceUser());
            }
            catch (EnsureServiceUserException e) {
                this.log.error("Error Ensuring Service User [ {} ]", (Object)ensureServiceUser.getServiceUser().getPrincipalName(), (Object)e);
            }
        }
    }

    @Override
    public final void ensurePrincipalName(String principalName) {
        for (EnsureServiceUser ensureServiceUser : this.ensureServiceUsers.values()) {
            if (!StringUtils.equals((String)principalName, (String)ensureServiceUser.getServiceUser().getPrincipalName())) continue;
            try {
                ensureServiceUser.ensure(ensureServiceUser.getOperation(), ensureServiceUser.getServiceUser());
            }
            catch (EnsureServiceUserException e) {
                this.log.error("Error Ensuring Service User [ {} ]", (Object)ensureServiceUser.getServiceUser().getPrincipalName(), (Object)e);
            }
        }
    }

    protected final void bindEnsureServiceUser(EnsureServiceUser service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("service.pid"), null);
        if (type != null) {
            this.ensureServiceUsers.put(type, service);
        }
    }

    protected final void unbindEnsureServiceUser(EnsureServiceUser service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("service.pid"), null);
        if (type != null) {
            this.ensureServiceUsers.remove(type);
        }
    }
}

