/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.Ace;
import com.adobe.acs.commons.users.impl.EnsureServiceUserException;
import com.adobe.acs.commons.users.impl.ProtectedSystemUsers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUser {
    private static final Logger log = LoggerFactory.getLogger(ServiceUser.class);
    private static final String PATH_SYSTEM_USERS = "/home/users/system";
    private final String principalName;
    private final String intermediatePath;
    private final List<Ace> aces = new ArrayList<Ace>();

    public ServiceUser(Map<String, Object> config) throws EnsureServiceUserException {
        String[] acesProperty;
        String tmp = PropertiesUtil.toString((Object)config.get("principalName"), null);
        if (StringUtils.contains((String)tmp, (String)"/")) {
            tmp = StringUtils.removeStart((String)tmp, (String)PATH_SYSTEM_USERS);
            tmp = StringUtils.removeStart((String)tmp, (String)"/");
            this.principalName = StringUtils.substringAfterLast((String)tmp, (String)"/");
            this.intermediatePath = PathUtil.makePath((String)PATH_SYSTEM_USERS, (String)StringUtils.removeEnd((String)tmp, (String)this.principalName));
        } else {
            this.principalName = tmp;
            this.intermediatePath = PATH_SYSTEM_USERS;
        }
        if (StringUtils.isBlank((String)this.principalName)) {
            throw new EnsureServiceUserException("No Principal Name provided to Ensure Service User");
        }
        if (ProtectedSystemUsers.isProtected(this.principalName)) {
            throw new EnsureServiceUserException(String.format("[ %s ] is an System User provided by AEM or ACS AEM Commons. You cannot ensure this user.", this.principalName));
        }
        for (String entry : acesProperty = PropertiesUtil.toStringArray((Object)config.get("aces"), (String[])new String[0])) {
            try {
                this.aces.add(new Ace(entry));
            }
            catch (EnsureServiceUserException e) {
                log.warn("Malformed ACE config [ " + entry + " ] for Service User [ " + StringUtils.defaultIfEmpty((String)this.principalName, (String)"NOT PROVIDED") + " ]", (Throwable)e);
            }
        }
    }

    public boolean hasAceAt(String path) {
        for (Ace ace : this.getAces()) {
            if (!StringUtils.equals((String)path, (String)ace.getContentPath())) continue;
            return true;
        }
        return false;
    }

    public String getIntermediatePath() {
        return this.intermediatePath;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public List<Ace> getAces() {
        return this.aces;
    }

    public Ace getAce(JackrabbitAccessControlEntry actual) throws RepositoryException {
        for (Ace ace : this.getAces()) {
            if (!ace.isSameAs(actual)) continue;
            return ace;
        }
        return null;
    }

    public List<Ace> getMissingAces() {
        ArrayList<Ace> result = new ArrayList<Ace>();
        for (Ace ace : this.getAces()) {
            if (ace.isExists()) continue;
            result.add(ace);
        }
        return result;
    }
}

