/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.util.StringWriterResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class ResourceDataUtil {
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(ResourceDataUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIncludeAsString(String path, SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse) {
        StringWriterResponse responseWrapper = null;
        try {
            responseWrapper = new StringWriterResponse(slingResponse);
            RequestDispatcher requestDispatcher = slingRequest.getRequestDispatcher(path);
            requestDispatcher.include((ServletRequest)slingRequest, (ServletResponse)responseWrapper);
            String string = StringUtils.stripToNull((String)responseWrapper.getString());
            return string;
        }
        catch (Exception ex) {
            log.error("Error creating the String representation for: " + path, (Throwable)ex);
        }
        finally {
            if (responseWrapper != null) {
                responseWrapper.clearWriter();
            }
        }
        return null;
    }

    public static InputStream getNTFileAsInputStream(String path, ResourceResolver resourceResolver) throws RepositoryException {
        return ResourceDataUtil.getNTFileAsInputStream(resourceResolver.resolve(path));
    }

    public static InputStream getNTFileAsInputStream(Resource resource) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        Node jcrContent = node.getNode("jcr:content");
        return jcrContent.getProperty("jcr:data").getBinary().getStream();
    }

    public static String getNTFileAsString(String path, ResourceResolver resourceResolver) throws RepositoryException, IOException {
        return ResourceDataUtil.getNTFileAsString(path, resourceResolver, ENCODING_UTF_8);
    }

    public static String getNTFileAsString(String path, ResourceResolver resourceResolver, String encoding) throws RepositoryException, IOException {
        return ResourceDataUtil.getNTFileAsString(resourceResolver.resolve(path), encoding);
    }

    public static String getNTFileAsString(Resource resource) throws RepositoryException, IOException {
        return ResourceDataUtil.getNTFileAsString(resource, ENCODING_UTF_8);
    }

    public static String getNTFileAsString(Resource resource, String encoding) throws RepositoryException, IOException {
        InputStream inputStream = ResourceDataUtil.getNTFileAsInputStream(resource);
        return IOUtils.toString((InputStream)inputStream, (String)encoding);
    }
}

