/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class WorkflowHelperImpl
implements WorkflowHelper {
    private static final Logger log = LoggerFactory.getLogger(WorkflowHelperImpl.class);
    private static final int MAX_GENERIC_QUALITY = 100;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private MimeTypeService mimeTypeService;

    @Override
    public final ResourceResolver getResourceResolver(WorkflowSession workflowSession) {
        return (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
    }

    @Override
    public final ResourceResolver getResourceResolver(com.day.cq.workflow.WorkflowSession workflowSession) throws LoginException {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", workflowSession.getSession());
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    @Override
    public WorkflowHelper.AssetResourceResolverPair getAssetFromPayload(WorkItem item, com.day.cq.workflow.WorkflowSession workflowSession) {
        Asset asset = null;
        if (item.getWorkflowData().getPayloadType().equals("JCR_PATH")) {
            ResourceResolver resourceResolver;
            String path = item.getWorkflowData().getPayload().toString();
            try {
                resourceResolver = this.getResourceResolver(workflowSession);
            }
            catch (LoginException e) {
                log.warn("Unable to create ResourceResolver from workflow session", (Throwable)e);
                return null;
            }
            Resource resource = resourceResolver.getResource(path);
            if (null != resource) {
                asset = DamUtil.resolveToAsset((Resource)resource);
                if (asset != null) {
                    return new WorkflowHelper.AssetResourceResolverPair(asset, resourceResolver);
                }
            } else {
                log.error("getAssetFromPaylod: asset [{}] in payload of workflow [{}] does not exist.", (Object)path, (Object)item.getWorkflow().getId());
            }
        }
        return null;
    }

    @Override
    public String getExtension(String mimetype) {
        return this.mimeTypeService.getExtension(mimetype);
    }

    @Override
    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get("PROCESS_ARGS", String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        return new String[0];
    }

    @Override
    public List<String> getValuesFromArgs(String name, String[] args) {
        String prefix = name + ":";
        int prefixLength = prefix.length();
        ArrayList<String> values = new ArrayList<String>();
        for (String arg : args) {
            if (!arg.startsWith(prefix)) continue;
            String value = arg.substring(prefixLength).trim();
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public double getQuality(double base, String qualityStr) {
        int q = Integer.parseInt(qualityStr);
        double res = base * (double)q / 100.0;
        return res;
    }

    @Override
    public final Resource getPageOrAssetResource(ResourceResolver resourceResolver, String path) {
        Resource payloadResource = resourceResolver.getResource(path);
        if (payloadResource == null) {
            return null;
        }
        Asset asset = DamUtil.resolveToAsset((Resource)payloadResource);
        if (asset != null) {
            return (Resource)asset.adaptTo(Resource.class);
        }
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(payloadResource);
        if (page != null) {
            return (Resource)page.adaptTo(Resource.class);
        }
        return null;
    }

    @Override
    public boolean isPathTypedPayload(com.day.cq.workflow.exec.WorkflowData workflowData) {
        return "JCR_PATH".equals(workflowData.getPayloadType());
    }

    @Override
    public boolean isPathTypedPayload(WorkflowData workflowData) {
        return "JCR_PATH".equals(workflowData.getPayloadType());
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

