/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.EvolutionEntry;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionEntryImpl;
import com.adobe.acs.commons.version.impl.EvolutionPathUtil;
import javax.jcr.Property;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentEvolutionEntryImpl
implements EvolutionEntry {
    private static final Logger log = LoggerFactory.getLogger(CurrentEvolutionEntryImpl.class);
    private static int MAX_CHARS = 200;
    private EvolutionEntry.EvolutionEntryType type;
    private String name;
    private Object value;
    private int depth;
    private String path;
    private EvolutionConfig config;

    public CurrentEvolutionEntryImpl(Resource resource, EvolutionConfig config) {
        this.config = config;
        this.type = EvolutionEntry.EvolutionEntryType.RESOURCE;
        this.name = resource.getName();
        this.depth = EvolutionPathUtil.getLastDepthForPath(resource.getPath());
        this.path = resource.getParent().getName();
        this.value = null;
    }

    public CurrentEvolutionEntryImpl(Property property, EvolutionConfig config) {
        try {
            this.config = config;
            this.type = EvolutionEntry.EvolutionEntryType.PROPERTY;
            this.name = property.getName();
            this.depth = EvolutionPathUtil.getLastDepthForPath(property.getPath());
            this.path = property.getParent().getName();
            this.value = EvolutionConfig.printProperty(property);
        }
        catch (Exception e) {
            log.error("Could not inititalize VersionEntry", (Throwable)e);
        }
    }

    @Override
    public boolean isResource() {
        return EvolutionEntry.EvolutionEntryType.RESOURCE == this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return (this.name + this.path).replace(":", "_").replace("/", "_").replace("@", "_").replace("content", "node");
    }

    @Override
    public EvolutionEntry.EvolutionEntryType getType() {
        return this.type;
    }

    @Override
    public String getValueString() {
        return EvolutionConfig.printObject(this.value);
    }

    @Override
    public String getValueStringShort() {
        String tmpValue = this.getValueString();
        if (tmpValue.length() > MAX_CHARS) {
            return tmpValue.substring(0, MAX_CHARS) + "...";
        }
        return tmpValue;
    }

    @Override
    public int getDepth() {
        return this.depth - 1;
    }

    @Override
    public boolean isCurrent() {
        return true;
    }

    @Override
    public String getStatus() {
        if (this.isChanged() && this.isWillBeRemoved()) {
            return EvolutionEntryImpl.V_CHANGED_REMOVED;
        }
        if (this.isAdded() && this.isWillBeRemoved()) {
            return EvolutionEntryImpl.V_ADDED_REMOVED;
        }
        if (this.isAdded()) {
            return EvolutionEntryImpl.V_ADDED;
        }
        if (this.isWillBeRemoved()) {
            return EvolutionEntryImpl.V_REMOVED;
        }
        if (this.isChanged()) {
            return EvolutionEntryImpl.V_CHANGED;
        }
        return "";
    }

    @Override
    public boolean isAdded() {
        return false;
    }

    @Override
    public boolean isWillBeRemoved() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return false;
    }
}

