/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl.lines;

import com.adobe.acs.commons.wcm.comparisons.impl.lines.LineImpl;
import com.adobe.acs.commons.wcm.comparisons.impl.lines.Stepper;
import com.adobe.acs.commons.wcm.comparisons.lines.Line;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LinesGenerator<T> {
    private final Function<T, Serializable> toId;
    private Stepper<T> left;
    private Stepper<T> right;
    private T leftValue;
    private int leftSpacer;
    private T rightValue;
    private int rightSpacer;

    public LinesGenerator(Function<T, Serializable> toId) {
        this.toId = toId;
    }

    public List<Line<T>> generate(Iterable<T> left, Iterable<T> right) {
        this.left = new Stepper<T>(left, this.toId);
        this.right = new Stepper<T>(right, this.toId);
        ArrayList<Line<T>> lines = new ArrayList<Line<T>>();
        this.leftValue = this.left.next();
        this.rightValue = this.right.next();
        do {
            this.leftSpacer = this.right.positionOfIdAfterCurrent(this.leftValue);
            this.rightSpacer = this.left.positionOfIdAfterCurrent(this.rightValue);
            if (this.leftValue != null && this.rightValue != null && ((Serializable)this.toId.apply(this.leftValue)).equals(this.toId.apply(this.rightValue))) {
                this.addPair(lines);
                continue;
            }
            if (this.leftSpacer < this.rightSpacer && this.leftSpacer > 0) {
                this.addWithLeftSpacers(lines);
                continue;
            }
            if (this.rightSpacer > 0) {
                this.addWithRightSpacers(lines);
                continue;
            }
            if (this.leftSpacer > 0) {
                this.addWithLeftSpacers(lines);
                continue;
            }
            this.addSeperated(lines);
        } while (this.leftValue != null || this.rightValue != null);
        return lines;
    }

    private void addSeperated(List<Line<T>> lines) {
        if (this.leftValue != null) {
            lines.add(LineImpl.left(this.leftValue));
            this.leftValue = this.left.next();
        }
        if (this.rightValue != null) {
            lines.add(LineImpl.right(this.rightValue));
            this.rightValue = this.right.next();
        }
    }

    private void addWithLeftSpacers(List<Line<T>> lines) {
        for (int i = 0; i < this.leftSpacer; ++i) {
            lines.add(LineImpl.right(this.rightValue));
            this.rightValue = this.right.next();
        }
    }

    private void addWithRightSpacers(List<Line<T>> lines) {
        for (int i = 0; i < this.rightSpacer; ++i) {
            lines.add(LineImpl.left(this.leftValue));
            this.leftValue = this.left.next();
        }
    }

    private void addPair(List<Line<T>> lines) {
        lines.add(LineImpl.both(this.leftValue, this.rightValue));
        this.leftValue = this.left.next();
        this.rightValue = this.right.next();
    }
}

