/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - File Importer", description="Importer which can import a file from the file system into the content repository.", metatype=true)
@Service
@Property(label="Display Name", description="Label which will be displayed in the Polling Importer Add... dialog", name="displayName", value={"File"})
public final class FileImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(FileImporter.class);
    private static final String DEFAULT_SCHEME = "file";
    @Reference
    private MimeTypeService mimeTypeService;
    @Property(label="Importer Scheme", description="Scheme value that will be used for this importer. Must be unique across importers.", value={"file"})
    private static final String PROP_SCHEME = "importer.scheme";
    private String scheme;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.scheme = PropertiesUtil.toString((Object)properties.get(PROP_SCHEME), (String)DEFAULT_SCHEME);
    }

    public void importData(String schemeValue, String dataSource, Resource target) {
        block30: {
            if (this.scheme.equals(schemeValue)) {
                File file = new File(dataSource);
                if (file.exists()) {
                    Calendar fileLastMod = Calendar.getInstance();
                    fileLastMod.setTimeInMillis(file.lastModified());
                    String fileName = file.getName();
                    String mimeType = this.mimeTypeService.getMimeType(fileName);
                    Node node = (Node)target.adaptTo(Node.class);
                    if (node != null) {
                        try (FileInputStream stream = new FileInputStream(file);){
                            String targetName;
                            Node targetParent;
                            if (node.isNodeType("nt:file")) {
                                targetParent = node.getParent();
                                targetName = node.getName();
                                Calendar nodeLastMod = JcrUtils.getLastModified((Node)node);
                                if (!nodeLastMod.before(fileLastMod)) {
                                    log.info("File '{}' does not have a newer timestamp than '{}'. Skipping import.", (Object)dataSource, (Object)target);
                                    return;
                                }
                            } else {
                                Node targetNode;
                                Calendar nodeLastMod;
                                targetParent = node;
                                targetName = fileName;
                                if (targetParent.hasNode(targetName) && !(nodeLastMod = JcrUtils.getLastModified((Node)(targetNode = targetParent.getNode(targetName)))).before(fileLastMod)) {
                                    log.info("File '{}' does not have a newer timestamp than '{}'. Skipping import.", (Object)dataSource, (Object)targetNode.getPath());
                                    return;
                                }
                            }
                            JcrUtils.putFile((Node)targetParent, (String)targetName, (String)mimeType, (InputStream)stream);
                            node.getSession().save();
                            break block30;
                        }
                        catch (RepositoryException e) {
                            throw new ImportException("Unable to import from file '" + dataSource + "' to '" + target.getPath() + "'", (Throwable)e);
                        }
                        catch (IOException e) {
                            throw new ImportException("Unexpected IOException while importing", (Throwable)e);
                        }
                    }
                    log.warn("Target '{}' is not a JCR node. Skipping import from '{}'.", (Object)target.getPath(), (Object)dataSource);
                } else {
                    log.warn("File at '{}' does not exist. Skipping import.", (Object)dataSource);
                }
            } else {
                log.warn("Unrecognized scheme '{}' passed to importData()", (Object)schemeValue);
            }
        }
    }

    public void importData(String schemeValue, String dataSource, Resource target, String login, String password) throws ImportException {
        this.importData(schemeValue, dataSource, target);
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

