/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.properties.shared.impl;

import com.adobe.acs.commons.wcm.PageRootProvider;
import com.adobe.acs.commons.wcm.properties.shared.SharedComponentProperties;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.commons.WCMUtils;
import java.util.HashMap;
import javax.script.Bindings;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class SharedComponentPropertiesBindingsValuesProvider
implements BindingsValuesProvider {
    private static final Logger log = LoggerFactory.getLogger(SharedComponentPropertiesBindingsValuesProvider.class);
    @Reference
    private PageRootProvider pageRootProvider;
    @Reference
    private SharedComponentProperties sharedComponentProperties;

    public void addBindings(Bindings bindings) {
        Resource resource = (Resource)bindings.get("resource");
        com.day.cq.wcm.api.components.Component component = WCMUtils.getComponent((Resource)resource);
        if (component != null) {
            if (this.pageRootProvider != null) {
                this.setSharedProperties(bindings, resource, component);
            } else {
                log.debug("Page Root Provider must be configured for shared component properties to be supported");
            }
            this.setMergedProperties(bindings, resource);
        }
    }

    private void setSharedProperties(Bindings bindings, Resource resource, com.day.cq.wcm.api.components.Component component) {
        Page pageRoot = this.pageRootProvider.getRootPage(resource);
        if (pageRoot != null) {
            String globalPropsPath = pageRoot.getPath() + "/jcr:content/" + "global-component-properties";
            Resource globalPropsResource = resource.getResourceResolver().getResource(globalPropsPath);
            if (globalPropsResource != null) {
                bindings.put("globalProperties", (Object)globalPropsResource.getValueMap());
            }
            String sharedPropsPath = pageRoot.getPath() + "/jcr:content/" + "shared-component-properties" + "/" + component.getResourceType();
            Resource sharedPropsResource = resource.getResourceResolver().getResource(sharedPropsPath);
            if (sharedPropsResource != null) {
                bindings.put("sharedProperties", (Object)sharedPropsResource.getValueMap());
            }
        } else {
            log.debug("Could not determine shared properties root for resource {}", (Object)resource.getPath());
        }
    }

    private void setMergedProperties(Bindings bindings, Resource resource) {
        ValueMap globalPropertyMap = (ValueMap)bindings.get("globalProperties");
        ValueMap sharedPropertyMap = (ValueMap)bindings.get("sharedProperties");
        ValueMap localPropertyMap = resource.getValueMap();
        bindings.put("mergedProperties", (Object)this.mergeProperties(localPropertyMap, sharedPropertyMap, globalPropertyMap));
    }

    private ValueMap mergeProperties(ValueMap instanceProperties, ValueMap sharedProperties, ValueMap globalProperties) {
        HashMap mergedProperties = new HashMap();
        if (globalProperties != null) {
            mergedProperties.putAll(globalProperties);
        }
        if (sharedProperties != null) {
            mergedProperties.putAll(sharedProperties);
        }
        if (instanceProperties != null) {
            mergedProperties.putAll(instanceProperties);
        }
        return new ValueMapDecorator(mergedProperties);
    }

    protected void bindPageRootProvider(PageRootProvider pageRootProvider) {
        this.pageRootProvider = pageRootProvider;
    }

    protected void unbindPageRootProvider(PageRootProvider pageRootProvider) {
        if (this.pageRootProvider == pageRootProvider) {
            this.pageRootProvider = null;
        }
    }

    protected void bindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        this.sharedComponentProperties = sharedComponentProperties;
    }

    protected void unbindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        if (this.sharedComponentProperties == sharedComponentProperties) {
            this.sharedComponentProperties = null;
        }
    }
}

