/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.properties.shared.impl;

import com.adobe.acs.commons.wcm.PageRootProvider;
import com.adobe.acs.commons.wcm.properties.shared.SharedComponentProperties;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageInfoProvider;
import com.day.cq.wcm.api.components.ComponentManager;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={PageInfoProvider.class})
public class SharedComponentPropertiesPageInfoProvider
implements PageInfoProvider,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(SharedComponentPropertiesPageInfoProvider.class);
    private static final String SERVICE_NAME = "shared-component-props";
    @Reference
    private PageRootProvider pageRootProvider;
    @Reference
    private SharedComponentProperties sharedComponentProperties;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository repository;
    private Session respositorySession;
    private ObservationManager observationManager;
    private Map<String, List<Boolean>> componentsWithSharedProperties;
    private long scheduledSharedComponentsMapUpdate = -1L;

    public void updatePageInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        JSONObject props;
        block6: {
            if (this.scheduledSharedComponentsMapUpdate > 0L && System.currentTimeMillis() > this.scheduledSharedComponentsMapUpdate) {
                this.scheduledSharedComponentsMapUpdate = -1L;
                this.updateSharedComponentsMap();
            }
            props = new JSONObject();
            props.put("enabled", false);
            Page page = this.pageRootProvider.getRootPage(resource);
            if (page != null) {
                Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
                try {
                    AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
                    Privilege privilegeAddChild = accessControlManager.privilegeFromName("jcr:addChildNodes");
                    Privilege privilegeModifyProps = accessControlManager.privilegeFromName("jcr:modifyProperties");
                    Privilege[] requiredPrivs = new Privilege[]{privilegeAddChild, privilegeModifyProps};
                    if (accessControlManager.hasPrivileges(page.getPath() + "/jcr:content", requiredPrivs)) {
                        props.put("enabled", true);
                        props.put("root", (Object)page.getPath());
                        props.put("components", Maps.transformValues(this.componentsWithSharedProperties, JSONArray::new));
                        break block6;
                    }
                    log.debug("User does not have [ {} ] on [ {} ]", (Object)requiredPrivs, (Object)(page.getPath() + "/jcr:content"));
                }
                catch (RepositoryException e) {
                    log.error("Unexpected error checking permissions to modify shared component properties", (Throwable)e);
                }
            } else {
                log.debug("No Page Root could be found for [ {} ]", (Object)resource.getPath());
            }
        }
        info.put("sharedComponentProperties", (Object)props);
    }

    public void onEvent(EventIterator eventIterator) {
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            try {
                String nodeName;
                String[] pathPieces = event.getPath().split("/");
                switch (nodeName = pathPieces[pathPieces.length - 1]) {
                    case "dialogglobal": 
                    case "dialogshared": 
                    case "dialog_global": 
                    case "dialog_shared": {
                        this.scheduleSharedComponentsMapUpdate();
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Error determining if event affects list of components with shared/global properties", (Throwable)e);
            }
        }
    }

    private void scheduleSharedComponentsMapUpdate() {
        log.debug("Flagging for rebuild of the map of components with shared properties dialogs");
        this.scheduledSharedComponentsMapUpdate = System.currentTimeMillis() + 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedComponentsMap() {
        try (ResourceResolver resourceResolver = null;){
            log.debug("Calculating map of components with shared properties dialogs");
            Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SERVICE_NAME);
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(authInfo);
            resourceResolver.refresh();
            ComponentManager componentManager = (ComponentManager)resourceResolver.adaptTo(ComponentManager.class);
            HashMap<String, List<Boolean>> localComponentsWithSharedProperties = new HashMap<String, List<Boolean>>();
            for (com.day.cq.wcm.api.components.Component component : componentManager.getComponents()) {
                if (!component.getPath().startsWith("/apps")) continue;
                boolean hasSharedDialogForTouch = this.componentHasTouchDialog(component, "dialogshared");
                boolean hasGlobalDialogForTouch = this.componentHasTouchDialog(component, "dialogglobal");
                boolean hasSharedDialogForClassic = this.componentHasClassicDialog(component, "dialog_shared");
                boolean hasGlobalDialogForClassic = this.componentHasClassicDialog(component, "dialog_global");
                if (!hasSharedDialogForTouch && !hasGlobalDialogForTouch && !hasSharedDialogForClassic && !hasGlobalDialogForClassic) continue;
                localComponentsWithSharedProperties.put(component.getResourceType(), Arrays.asList(hasSharedDialogForTouch, hasGlobalDialogForTouch, hasSharedDialogForClassic, hasGlobalDialogForClassic));
            }
            this.componentsWithSharedProperties = Collections.unmodifiableMap(localComponentsWithSharedProperties);
            log.debug("Calculated map of components with shared properties dialogs: {}", this.componentsWithSharedProperties);
        }
    }

    private boolean componentHasClassicDialog(com.day.cq.wcm.api.components.Component component, String dialogName) throws RepositoryException {
        Resource dialog = component.getLocalResource(dialogName);
        return dialog != null && ((Node)dialog.adaptTo(Node.class)).isNodeType("cq:Dialog");
    }

    private boolean componentHasTouchDialog(com.day.cq.wcm.api.components.Component component, String dialogName) {
        Resource dialog = component.getLocalResource(dialogName);
        return dialog != null && dialog.isResourceType("cq/gui/components/authoring/dialog");
    }

    @Activate
    public void activate(Map<String, String> config) throws RepositoryException {
        this.componentsWithSharedProperties = new HashMap<String, List<Boolean>>();
        this.scheduleSharedComponentsMapUpdate();
        try {
            this.respositorySession = this.repository.loginService(SERVICE_NAME, null);
            this.observationManager = this.respositorySession.getWorkspace().getObservationManager();
            String[] nodeTypes = new String[]{"nt:folder", "nt:unstructured"};
            int eventTypes = 3;
            this.observationManager.addEventListener((EventListener)this, eventTypes, "/apps", true, null, nodeTypes, true);
            log.info("Activated JCR event listener for components with shared/global properties");
        }
        catch (LoginException le) {
            log.error("Could not get an admin resource resolver to listen for components with shared/global properties");
        }
        catch (Exception e) {
            log.error("Error activating JCR event listener for components with shared/global properties", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate(Map<String, String> config) throws RepositoryException {
        this.scheduledSharedComponentsMapUpdate = -1L;
        try {
            if (this.observationManager != null) {
                this.observationManager.removeEventListener((EventListener)this);
                log.info("Deactivated JCR event listener for components with shared/global properties");
            }
        }
        catch (RepositoryException re) {
            log.error("Error deactivating JCR event listener for components with shared/global properties", (Throwable)re);
        }
        finally {
            if (this.respositorySession != null) {
                this.respositorySession.logout();
                this.respositorySession = null;
            }
        }
    }

    protected void bindPageRootProvider(PageRootProvider pageRootProvider) {
        this.pageRootProvider = pageRootProvider;
    }

    protected void unbindPageRootProvider(PageRootProvider pageRootProvider) {
        if (this.pageRootProvider == pageRootProvider) {
            this.pageRootProvider = null;
        }
    }

    protected void bindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        this.sharedComponentProperties = sharedComponentProperties;
    }

    protected void unbindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        if (this.sharedComponentProperties == sharedComponentProperties) {
            this.sharedComponentProperties = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

