/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.runners;

import com.adobe.acs.commons.util.QueryHelper;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.PayloadGroup;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.SubStatus;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkflowRunner
implements BulkWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowRunner.class);
    private static final int SAVE_THRESHOLD = 1000;
    protected static final String SERVICE_NAME = "bulk-workflow-runner";
    protected static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "bulk-workflow-runner");

    @Override
    public void initialize(QueryHelper queryHelper, Config config) throws PersistenceException, RepositoryException {
        ResourceResolver resourceResolver = config.getResourceResolver();
        List<Resource> resources = queryHelper.findResources(resourceResolver, config.getQueryType(), config.getQueryStatement(), config.getRelativePath());
        int total = 0;
        Node workspace = JcrUtils.getOrAddNode((Node)((Node)config.getResource().adaptTo(Node.class)), (String)"workspace", (String)"oak:Unstructured");
        Node currentPayloadGroup = JcrUtils.getOrCreateByPath((Node)workspace, (String)"payloads_zero", (boolean)true, (String)"oak:Unstructured", (String)"oak:Unstructured", (boolean)false);
        JcrUtil.setProperty((Node)workspace, (String)"activePayloadGroups", (Object)new String[]{PayloadGroup.dereference(currentPayloadGroup.getPath())});
        ListIterator<Resource> itr = resources.listIterator();
        while (itr.hasNext()) {
            if (total % config.getBatchSize() == 0 && itr.hasNext()) {
                Node nextPayloadGroup = JcrUtils.getOrCreateByPath((Node)workspace, (String)"payloads", (boolean)true, (String)"oak:Unstructured", (String)"oak:Unstructured", (boolean)false);
                JcrUtil.setProperty((Node)currentPayloadGroup, (String)"next", (Object)PayloadGroup.dereference(nextPayloadGroup.getPath()));
                currentPayloadGroup = nextPayloadGroup;
            }
            Resource payload = itr.next();
            Node payloadNode = JcrUtils.getOrCreateByPath((Node)currentPayloadGroup, (String)"payload", (boolean)true, (String)"oak:Unstructured", (String)"oak:Unstructured", (boolean)false);
            JcrUtil.setProperty((Node)payloadNode, (String)"path", (Object)Payload.dereference(payload.getPath()));
            log.debug("Created payload with search result [ {} ]", (Object)payload.getPath());
            if (++total % 1000 != 0 && itr.hasNext()) continue;
            resourceResolver.commit();
        }
        if (total <= 0) {
            throw new IllegalArgumentException("Query returned zero results.");
        }
        config.getWorkspace().getRunner().initialize(config.getWorkspace(), total);
        config.commit();
        log.info("Completed initialization of Bulk Workflow Manager");
    }

    @Override
    public void initialize(Workspace workspace, int totalCount) throws PersistenceException {
        workspace.setInitialized(true);
        workspace.setTotalCount(totalCount);
        workspace.commit();
    }

    @Override
    public void start(Workspace workspace) throws PersistenceException {
        workspace.setStatus(Status.RUNNING);
        if (workspace.getStartedAt() == null) {
            workspace.setStartedAt(Calendar.getInstance());
        }
        workspace.commit();
    }

    @Override
    public void stopping(Workspace workspace) throws PersistenceException {
        workspace.setStatus(Status.RUNNING, SubStatus.STOPPING);
        workspace.commit();
    }

    @Override
    public void stop(Workspace workspace) throws PersistenceException {
        workspace.setStatus(Status.STOPPED);
        workspace.setStoppedAt(Calendar.getInstance());
        workspace.commit();
    }

    @Override
    public void stop(Workspace workspace, SubStatus subStatus) throws PersistenceException {
        if (subStatus != null) {
            workspace.setStatus(Status.STOPPED, subStatus);
        } else {
            workspace.setStatus(Status.STOPPED);
        }
        workspace.setStoppedAt(Calendar.getInstance());
        workspace.commit();
    }

    @Override
    public void stopWithError(Workspace workspace) throws PersistenceException {
        workspace.setStatus(Status.STOPPED, SubStatus.ERROR);
        workspace.setStoppedAt(Calendar.getInstance());
        workspace.commit();
    }

    @Override
    public void complete(Workspace workspace) throws PersistenceException {
        workspace.setStatus(Status.COMPLETED);
        workspace.setCompletedAt(Calendar.getInstance());
        workspace.commit();
    }

    @Override
    public void complete(Workspace workspace, Payload payload) throws Exception {
        if (workspace != null) {
            workspace.removeActivePayload(payload);
            workspace.incrementCompleteCount();
        } else {
            log.warn("Unable to processing complete for payload [ {} ~> {} ]", (Object)payload.getPath(), (Object)payload.getPayloadPath());
        }
    }

    @Override
    public void run(Workspace workspace, Payload payload) {
        payload.setStatus(Status.RUNNING);
    }

    public void fail(Workspace workspace, Payload payload) throws Exception {
        workspace.removeActivePayload(payload);
        workspace.incrementFailCount();
        workspace.addFailure(payload);
    }

    @Override
    public abstract void forceTerminate(Workspace var1, Payload var2) throws Exception;
}

