/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.execution.impl.servlets.JSONErrorUtil;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"resume"}, extensions={"json"})
public class ResumeServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ResumeServlet.class);
    @Reference
    private BulkWorkflowEngine bulkWorkflowEngine;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            Config config = (Config)request.getResource().adaptTo(Config.class);
            int throttle = params.optInt("throttle", -1);
            int interval = params.optInt("interval", -1);
            if (throttle > -1) {
                config.setThrottle(throttle);
                config.commit();
            } else if (interval > -1) {
                config.setInterval(interval);
                config.commit();
            }
            this.bulkWorkflowEngine.resume(config);
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, request.getResource().getPath()) + ".status.json");
        }
        catch (JSONException e) {
            log.error("Could not resume Bulk Workflow due to: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not resume Bulk Workflow.", e.getMessage());
        }
    }

    protected void bindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        this.bulkWorkflowEngine = bulkWorkflowEngine;
    }

    protected void unbindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        if (this.bulkWorkflowEngine == bulkWorkflowEngine) {
            this.bulkWorkflowEngine = null;
        }
    }
}

