/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class Failure {
    public static final String PN_PATH = "path";
    public static final String PN_PAYLOAD_PATH = "payloadPath";
    public static final String PN_FAILED_AT = "failedAt";
    @Inject
    @Optional
    private String path;
    @Inject
    private String payloadPath;
    @Inject
    private Calendar failedAt;

    public String getPath() {
        return StringUtils.removeStart((String)this.path, (String)"-");
    }

    public String getPayloadPath() {
        return StringUtils.removeStart((String)this.payloadPath, (String)"-");
    }

    public String getDereferencedPath() {
        return this.path;
    }

    public String getDereferencedPayloadPath() {
        return this.payloadPath;
    }

    public Calendar getFailedAt() {
        return this.failedAt;
    }

    public JSONObject toJSON() throws JSONException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss aaa");
        JSONObject json = new JSONObject();
        json.put(PN_PATH, (Object)this.getPath());
        json.put(PN_PAYLOAD_PATH, (Object)this.getPayloadPath());
        json.put(PN_FAILED_AT, (Object)sdf.format(this.getFailedAt().getTime()));
        return json;
    }
}

