/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl.servlets;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import java.io.IOException;
import java.util.Arrays;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/workflow-remover"}, selectors={"init"}, extensions={"json"})
public class InitServlet
extends SlingSafeMethodsServlet {
    private static final String[] WORKFLOW_STATUSES = new String[]{"COMPLETED", "ABORTED", "RUNNING", "SUSPENDED", "STALE"};
    @Reference
    private WorkflowService workflowService;

    public final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JSONObject json = new JSONObject();
        try {
            json.put("form", (Object)this.getFormJSONObject(request.getResourceResolver()));
            response.getWriter().write(json.toString());
        }
        catch (Exception e) {
            response.setStatus(500);
            response.getWriter().write(e.getMessage());
        }
    }

    private JSONObject getFormJSONObject(ResourceResolver resourceResolver) throws WorkflowException, JSONException {
        WorkflowModel[] workflowModels;
        JSONObject json = new JSONObject();
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)resourceResolver.adaptTo(Session.class));
        for (WorkflowModel workflowModel : workflowModels = workflowSession.getModels()) {
            JSONObject jsonWorkflow = new JSONObject();
            jsonWorkflow.put("title", (Object)workflowModel.getTitle());
            jsonWorkflow.put("id", (Object)workflowModel.getId());
            json.accumulate("workflowModels", (Object)jsonWorkflow);
        }
        json.put("statuses", (Object)new JSONArray(Arrays.asList(WORKFLOW_STATUSES)));
        return json;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

