/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.adobe.cq.dam.mac.sync.api.DAMSyncService;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.replication.ReplicationActionType;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Workflow Process - Brand Portal Sync", description="Syncs assets with AEM Assets Brand Portal.")
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"Brand Portal Sync"}, description="Syncs (publish/unpublish) assets with AEM Assets Brand Portal")})
@Service
public class BrandPortalSyncProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(BrandPortalSyncProcess.class);
    @Reference
    private WorkflowHelper workflowHelper;
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private DAMSyncService damSyncService;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resourceResolver = null;
        ArrayList<String> assetPaths = new ArrayList<String>();
        ReplicationActionType replicationActionType = this.getReplicationActionType(metaDataMap);
        try {
            resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, (String)workItem.getWorkflowData().getPayload());
            for (String payload : payloads) {
                Asset asset = DamUtil.resolveToAsset((Resource)resourceResolver.getResource(payload));
                if (asset == null) {
                    log.debug("Payload path [ {} ] does not resolve to an asset", (Object)payload);
                    continue;
                }
                assetPaths.add(asset.getPath());
            }
            if (ReplicationActionType.ACTIVATE.equals((Object)replicationActionType)) {
                this.damSyncService.publishResourcesToMP(assetPaths, resourceResolver);
            } else if (ReplicationActionType.DEACTIVATE.equals((Object)replicationActionType)) {
                this.damSyncService.unpublishResourcesFromMP(assetPaths, resourceResolver);
            } else {
                log.warn("Unknown replication action type [ {} ] for AEM Assets Brand Portal Sync", (Object)replicationActionType);
            }
        }
        catch (RepositoryException e) {
            log.error("Could not find the payload", (Throwable)e);
            throw new WorkflowException("Could not find the payload");
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected final ReplicationActionType getReplicationActionType(MetaDataMap metaDataMap) {
        String processArgs = StringUtils.trim((String)((String)metaDataMap.get("PROCESS_ARGS", (Object)ReplicationActionType.ACTIVATE.getName())));
        if (StringUtils.equalsIgnoreCase((String)processArgs, (String)ReplicationActionType.ACTIVATE.getName())) {
            return ReplicationActionType.ACTIVATE;
        }
        if (StringUtils.equalsIgnoreCase((String)processArgs, (String)ReplicationActionType.DEACTIVATE.getName())) {
            return ReplicationActionType.DEACTIVATE;
        }
        return null;
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }

    protected void bindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        this.workflowPackageManager = workflowPackageManager;
    }

    protected void unbindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        if (this.workflowPackageManager == workflowPackageManager) {
            this.workflowPackageManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindDamSyncService(DAMSyncService dAMSyncService) {
        this.damSyncService = dAMSyncService;
    }

    protected void unbindDamSyncService(DAMSyncService dAMSyncService) {
        if (this.damSyncService == dAMSyncService) {
            this.damSyncService = null;
        }
    }
}

