/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl.cq;

import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowData;
import com.adobe.acs.commons.workflow.synthetic.impl.cq.SyntheticWorkItem;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.filter.WorkItemFilter;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;

public class SyntheticWorkflow
implements Workflow {
    private final String id;
    private final Date timeStarted;
    private SyntheticWorkflowData workflowData;
    private SyntheticWorkItem activeWorkItem;

    public SyntheticWorkflow(String id, SyntheticWorkflowData workflowData) {
        this.id = id;
        this.workflowData = workflowData;
        this.timeStarted = new Date();
    }

    public final void setActiveWorkItem(SyntheticWorkItem workItem) {
        this.activeWorkItem = workItem;
    }

    public final String getId() {
        return this.id;
    }

    public final List<WorkItem> getWorkItems() {
        return Arrays.asList(this.activeWorkItem);
    }

    public final List<WorkItem> getWorkItems(WorkItemFilter workItemFilter) {
        ArrayList<WorkItem> filtered = new ArrayList<WorkItem>();
        for (WorkItem workItem : this.getWorkItems()) {
            if (!workItemFilter.doInclude(workItem)) continue;
            filtered.add(workItem);
        }
        return filtered;
    }

    public final WorkflowModel getWorkflowModel() {
        return null;
    }

    public final boolean isActive() {
        return true;
    }

    public final String getState() {
        return "Synthetic Running";
    }

    public final String getInitiator() {
        return "Synthetic Workflow";
    }

    public final Date getTimeStarted() {
        return (Date)this.timeStarted.clone();
    }

    public final Date getTimeEnded() {
        return null;
    }

    public final WorkflowData getWorkflowData() {
        return this.workflowData;
    }

    public final void setWorkflowData(WorkflowData workflowData) {
        this.workflowData.resetTo(workflowData);
    }

    @Deprecated
    public final Dictionary<String, String> getMetaData() {
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (String key : this.getMetaDataMap().keySet()) {
            ((Dictionary)dictionary).put(key, (String)this.getMetaDataMap().get(key, String.class));
        }
        return dictionary;
    }

    public final MetaDataMap getMetaDataMap() {
        return this.getWorkflowData().getMetaDataMap();
    }
}

