/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.genericlists.impl;

import com.adobe.acs.commons.genericlists.GenericList;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Generic List JSON Resource Provider", description="Resource Provider which makes Generic Lists available as JSON structures suitable for use in the Touch UI Asset Metadata Editor")
@Service(value={ResourceProvider.class})
@Properties(value={@Property(name="provider.root", value={"/mnt/acs-commons/lists"})})
public final class GenericListJsonResourceProvider
extends ResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(GenericListJsonResourceProvider.class);
    static final String ROOT = "/mnt/acs-commons/lists";
    static final String DEFAULT_LIST_ROOT = "/etc/acs-commons/lists";
    private static final String EXTENSION = ".json";
    private static final int EXTENSION_LENGTH = ".json".length();
    @Property(label="Generic List Root", description="Root path under which generic lists can be found", value={"/etc/acs-commons/lists"})
    private static final String PROP_LIST_ROOT = "list.root";
    private String listRoot;

    @Activate
    protected void activate(Map<String, String> props) {
        this.listRoot = PropertiesUtil.toString((Object)props.get(PROP_LIST_ROOT), (String)DEFAULT_LIST_ROOT);
    }

    public Resource getResource(ResolveContext rc, String path, ResourceContext resourcecontext, Resource parent) {
        ResourceResolver resourceResolver = rc.getResourceResolver();
        if (path == null) {
            return null;
        }
        if (path.equals(ROOT)) {
            return null;
        }
        String listPath = path.endsWith(EXTENSION) ? path.substring(ROOT.length(), path.length() - EXTENSION_LENGTH) : path.substring(ROOT.length());
        String fullListPath = this.listRoot + listPath;
        Page listPage = ((PageManager)resourceResolver.adaptTo(PageManager.class)).getPage(fullListPath);
        if (listPage == null) {
            return null;
        }
        GenericList list = (GenericList)listPage.adaptTo(GenericList.class);
        if (list == null) {
            return null;
        }
        ResourceMetadata rm = new ResourceMetadata();
        rm.setResolutionPath(path);
        return new JsonResource(list, resourceResolver, rm);
    }

    public Iterator<Resource> listChildren(ResolveContext rc, Resource parent) {
        return null;
    }

    private static class JsonResource
    extends SyntheticResource {
        private GenericList list;

        public JsonResource(GenericList list, ResourceResolver resourceResolver, ResourceMetadata rm) {
            super(resourceResolver, rm, "acs-commons/components/utilities/genericlist/json");
            this.list = list;
        }

        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type == InputStream.class) {
                try {
                    HashMap<String, List<GenericList.Item>> out = new HashMap<String, List<GenericList.Item>>();
                    out.put("options", this.list.getItems());
                    Gson gson = new Gson();
                    String json = gson.toJson(out);
                    return (AdapterType)new ByteArrayInputStream(json.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("Unable to generate JSON object.", (Throwable)e);
                    return null;
                }
            }
            return (AdapterType)super.adaptTo(type);
        }
    }
}

