/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.hc.impl;

import com.adobe.acs.commons.email.EmailService;
import com.adobe.acs.commons.util.ModeUtil;
import com.adobe.granite.license.ProductInfo;
import com.adobe.granite.license.ProductInfoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.api.execution.HealthCheckExecutor;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Health Check Status E-mailer", description="Scheduled Service that runs specified Health Checks and e-mails the results", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(label="Cron expression defining when this Scheduled Service will run", name="scheduler.expression", description="Every weekday @ 8am = [ 0 0 8 ? * MON-FRI * ] Visit www.cronmaker.com to generate cron expressions.", value={"0 0 8 ? * MON-FRI *"}), @Property(name="scheduler.concurrent", boolValue={false}, propertyPrivate=true), @Property(name="scheduler.runOn", value={"LEADER"}, propertyPrivate=true)})
@Service(value={Runnable.class})
public class HealthCheckStatusEmailer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckStatusEmailer.class);
    private static final int HEALTH_CHECK_STATUS_PADDING = 20;
    private static final int NUM_DASHES = 100;
    private volatile Calendar nextEmailTime = Calendar.getInstance();
    private static final String DEFAULT_EMAIL_TEMPLATE_PATH = "/etc/notification/email/acs-commons/health-check-status-email.txt";
    private String emailTemplatePath = "/etc/notification/email/acs-commons/health-check-status-email.txt";
    @Property(label="E-mail Template Path", description="The absolute JCR path to the e-mail template", value={"/etc/notification/email/acs-commons/health-check-status-email.txt"})
    public static final String PROP_TEMPLATE_PATH = "email.template.path";
    private static final String DEFAULT_EMAIL_SUBJECT_PREFIX = "AEM Health Check report";
    private String emailSubject = "AEM Health Check report";
    @Property(label="E-mail Subject Prefix", description="The e-mail subject prefix. E-mail subject format is: <E-mail Subject Prefix> [ # Failures ] [ # Success ] [ <AEM Instance Name> ]", value={"AEM Health Check report"})
    public static final String PROP_EMAIL_SUBJECT = "email.subject";
    private static final boolean DEFAULT_SEND_EMAIL_ONLY_ON_FAILURE = true;
    private boolean sendEmailOnlyOnFailure = true;
    @Property(label="Send e-mail only on failure", description="If true, an e-mail is ONLY sent if at least 1 Health Check failure occurs. [ Default: true ]", boolValue={true})
    public static final String PROP_SEND_EMAIL_ONLY_ON_FAILURE = "email.send-only-on-failure";
    private static final String[] DEFAULT_RECIPIENT_EMAIL_ADDRESSES = new String[0];
    private String[] recipientEmailAddresses = DEFAULT_RECIPIENT_EMAIL_ADDRESSES;
    @Property(label="Recipient E-mail Addresses", description="A list of e-mail addresses to send this e-mail to.", cardinality=0x7FFFFFFF, value={})
    public static final String PROP_RECIPIENTS_EMAIL_ADDRESSES = "recipients.email-addresses";
    private static final String[] DEFAULT_HEALTH_CHECK_TAGS = new String[]{"system"};
    private String[] healthCheckTags = DEFAULT_HEALTH_CHECK_TAGS;
    @Property(label="Health Check Tags", description="The AEM Health Check Tag names to execute. [ Default: system ]", cardinality=0x7FFFFFFF, value={"system"})
    public static final String PROP_HEALTH_CHECK_TAGS = "hc.tags";
    private static final int DEFAULT_HEALTH_CHECK_TIMEOUT_OVERRIDE = -1;
    private int healthCheckTimeoutOverride = -1;
    @Property(label="Health Check Timeout Override", description="The AEM Health Check timeout override in milliseconds. Set < 1 to disable. [ Default: -1 ]", intValue={-1})
    public static final String PROP_HEALTH_CHECK_TIMEOUT_OVERRIDE = "hc.timeout.override";
    private static final boolean DEFAULT_HEALTH_CHECK_TAGS_OPTIONS_OR = true;
    private boolean healthCheckTagsOptionsOr = true;
    @Property(label="'OR' Health Check Tags", description="When set to true, all Health Checks that are in any of the Health Check Tags (hc.tags) are executed. If false, then the Health Check must be in ALL of the Health Check tags (hc.tags). [ Default: true ]", boolValue={true})
    public static final String PROP_HEALTH_CHECK_TAGS_OPTIONS_OR = "hc.tags.options.or";
    private static final String DEFAULT_FALLBACK_HOSTNAME = "Unknown AEM Instance";
    private String fallbackHostname = "Unknown AEM Instance";
    @Property(label="Hostname Fallback", description="The value used to identify this AEM instance if the programmatic hostname look-up fails to produce results..", value={"Unknown AEM Instance"})
    public static final String PROP_FALLBACK_HOSTNAME = "hostname.fallback";
    private static final int DEFAULT_THROTTLE_IN_MINS = 15;
    private int throttleInMins = 15;
    @Property(label="Quiet Period in Minutes", description="Defines a time span that prevents this service from sending more than 1 e-mail per quiet period. This prevents e-mail spamming for frequent checks that only e-mail on failure. Default: [ 15 mins ]", intValue={15})
    public static final String PROP_THROTTLE = "quiet.minutes";
    @Property(name="webconsole.configurationFactory.nameHint", value={"Health Check Status E-mailer running every [ {scheduler.expression} ] using Health Check Tags [ {hc.tags} ] to [ {recipients.email-addresses} ]"})
    @Reference
    private ProductInfoService productInfoService;
    @Reference
    private SlingSettingsService slingSettingsService;
    @Reference
    private EmailService emailService;
    @Reference
    private HealthCheckExecutor healthCheckExecutor;

    @Override
    public final void run() {
        log.trace("Executing ACS Commons Health Check E-mailer scheduled service");
        ArrayList<HealthCheckExecutionResult> success = new ArrayList<HealthCheckExecutionResult>();
        ArrayList<HealthCheckExecutionResult> failure = new ArrayList<HealthCheckExecutionResult>();
        long start = System.currentTimeMillis();
        HealthCheckExecutionOptions options = new HealthCheckExecutionOptions();
        options.setForceInstantExecution(true);
        options.setCombineTagsWithOr(this.healthCheckTagsOptionsOr);
        if (this.healthCheckTimeoutOverride > 0) {
            options.setOverrideGlobalTimeout(this.healthCheckTimeoutOverride);
        }
        List results = this.healthCheckExecutor.execute(options, this.healthCheckTags);
        log.debug("Obtained [ {} ] results for Health Check tags [ {} ]", (Object)results.size(), (Object)StringUtils.join((Object[])this.healthCheckTags, (String)", "));
        for (HealthCheckExecutionResult result : results) {
            if (result.getHealthCheckResult().isOk()) {
                success.add(result);
                continue;
            }
            failure.add(result);
        }
        long timeTaken = System.currentTimeMillis() - start;
        log.info("Executed ACS Commons Health Check E-mailer scheduled service in [ {} ms ]", (Object)timeTaken);
        if (!this.sendEmailOnlyOnFailure || failure.size() > 0) {
            Calendar now = Calendar.getInstance();
            if (this.nextEmailTime == null || now.equals(this.nextEmailTime) || now.after(this.nextEmailTime)) {
                this.sendEmail(success, failure, timeTaken);
                now.add(12, this.throttleInMins);
                this.nextEmailTime = now;
            } else {
                log.info("Did not send e-mail as it did not meet the e-mail throttle configured time of a [ {} ] minute quiet period. Next valid time to e-mail is [ {} ]", (Object)this.throttleInMins, (Object)this.nextEmailTime.getTime());
            }
        } else {
            log.debug("Declining to send e-mail notification of 100% successful Health Check execution due to configuration.");
        }
    }

    protected final void sendEmail(List<HealthCheckExecutionResult> success, List<HealthCheckExecutionResult> failure, long timeTaken) {
        ProductInfo[] productInfos = this.productInfoService.getInfos();
        String hostname = this.getHostname();
        HashMap<String, String> emailParams = new HashMap<String, String>();
        emailParams.put("subject", String.format("%s [ %d Failures ] [ %d Success ] [ %s ]", this.emailSubject, failure.size(), success.size(), hostname));
        emailParams.put("failure", this.resultToPlainText("Failing Health Checks", failure));
        emailParams.put("success", this.resultToPlainText("Successful Health Checks", success));
        emailParams.put("executedAt", Calendar.getInstance().getTime().toString());
        emailParams.put("runModes", StringUtils.join((Iterable)this.slingSettingsService.getRunModes(), (String)", "));
        emailParams.put("mode", ModeUtil.isAuthor() ? "Author" : "Publish");
        emailParams.put("hostname", hostname);
        emailParams.put("timeTaken", String.valueOf(timeTaken));
        if (productInfos.length == 1) {
            emailParams.put("productName", productInfos[0].getShortName());
            emailParams.put("productVersion", productInfos[0].getShortVersion());
        }
        emailParams.put("successCount", String.valueOf(success.size()));
        emailParams.put("failureCount", String.valueOf(failure.size()));
        emailParams.put("totalCount", String.valueOf(failure.size() + success.size()));
        if (ArrayUtils.isNotEmpty((Object[])this.recipientEmailAddresses)) {
            List<String> failureList = this.emailService.sendEmail(this.emailTemplatePath, emailParams, this.recipientEmailAddresses);
            if (failureList.size() > 0) {
                log.warn("Could not send health status check e-mails to recipients [ {} ]", (Object)StringUtils.join(failureList, (String)", "));
            } else {
                log.info("Successfully sent Health Check email to [ {} ] recipients", (Object)(this.recipientEmailAddresses.length - failureList.size()));
            }
        } else {
            log.warn("No e-mail addresses provided to e-mail results of health checks. Either add the appropriate e-mail recipients or remove the health check status e-mail configuration entirely.");
        }
    }

    protected String resultToPlainText(String title, List<HealthCheckExecutionResult> results) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(System.lineSeparator());
        if (results.size() == 0) {
            sb.append("No " + StringUtils.lowerCase((String)title) + " could be found!");
            sb.append(System.lineSeparator());
        } else {
            sb.append(StringUtils.repeat((String)"-", (int)100));
            sb.append(System.lineSeparator());
            for (HealthCheckExecutionResult result : results) {
                sb.append(StringUtils.rightPad((String)("[ " + result.getHealthCheckResult().getStatus().name() + " ]"), (int)20));
                sb.append("  ");
                sb.append(result.getHealthCheckMetadata().getTitle());
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    @Activate
    protected final void activate(Map<String, Object> config) {
        this.emailTemplatePath = PropertiesUtil.toString((Object)config.get(PROP_TEMPLATE_PATH), (String)DEFAULT_EMAIL_TEMPLATE_PATH);
        this.emailSubject = PropertiesUtil.toString((Object)config.get(PROP_EMAIL_SUBJECT), (String)DEFAULT_EMAIL_SUBJECT_PREFIX);
        this.fallbackHostname = PropertiesUtil.toString((Object)config.get(PROP_FALLBACK_HOSTNAME), (String)DEFAULT_FALLBACK_HOSTNAME);
        this.recipientEmailAddresses = PropertiesUtil.toStringArray((Object)config.get(PROP_RECIPIENTS_EMAIL_ADDRESSES), (String[])DEFAULT_RECIPIENT_EMAIL_ADDRESSES);
        this.healthCheckTags = PropertiesUtil.toStringArray((Object)config.get(PROP_HEALTH_CHECK_TAGS), (String[])DEFAULT_HEALTH_CHECK_TAGS);
        this.healthCheckTagsOptionsOr = PropertiesUtil.toBoolean((Object)config.get(PROP_HEALTH_CHECK_TAGS_OPTIONS_OR), (boolean)true);
        this.sendEmailOnlyOnFailure = PropertiesUtil.toBoolean((Object)config.get(PROP_SEND_EMAIL_ONLY_ON_FAILURE), (boolean)true);
        this.throttleInMins = PropertiesUtil.toInteger((Object)config.get(PROP_THROTTLE), (int)15);
        if (this.throttleInMins < 0) {
            this.throttleInMins = 15;
        }
        this.healthCheckTimeoutOverride = PropertiesUtil.toInteger((Object)config.get(PROP_HEALTH_CHECK_TIMEOUT_OVERRIDE), (int)-1);
    }

    private String getHostname() {
        String hostname = null;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            hostname = System.getenv("COMPUTERNAME");
            if (StringUtils.isBlank((CharSequence)hostname)) {
                try {
                    hostname = this.execReadToString("hostname");
                }
                catch (IOException ex) {
                    log.warn("Unable to collect hostname from Windows via 'hostname' command.", (Throwable)ex);
                }
            }
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("mac") >= 0) {
            hostname = System.getenv("HOSTNAME");
            if (StringUtils.isBlank((CharSequence)hostname)) {
                try {
                    hostname = this.execReadToString("hostname");
                }
                catch (IOException ex) {
                    log.warn("Unable to collect hostname from *nix via 'hostname' command.", (Throwable)ex);
                }
            }
            if (StringUtils.isBlank((CharSequence)hostname)) {
                try {
                    this.execReadToString("cat /etc/hostname");
                }
                catch (IOException ex) {
                    log.warn("Unable to collect hostname from *nix via 'cat /etc/hostname' command.", (Throwable)ex);
                }
            }
        } else {
            log.warn("Unidentifiable OS [ {} ]. Could not collect hostname.", (Object)os);
        }
        if (StringUtils.isBlank((CharSequence)(hostname = StringUtils.trimToNull((String)hostname)))) {
            log.debug("Unable to derive hostname from OS; defaulting to OSGi Configured value [ {} ]", (Object)this.fallbackHostname);
            return this.fallbackHostname;
        }
        log.debug("Derived hostname from OS: [ {} ]", (Object)hostname);
        return hostname;
    }

    /*
     * Exception decompiling
     */
    private String execReadToString(String execCommand) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void bindProductInfoService(ProductInfoService productInfoService) {
        this.productInfoService = productInfoService;
    }

    protected void unbindProductInfoService(ProductInfoService productInfoService) {
        if (this.productInfoService == productInfoService) {
            this.productInfoService = null;
        }
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    protected void bindEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    protected void unbindEmailService(EmailService emailService) {
        if (this.emailService == emailService) {
            this.emailService = null;
        }
    }

    protected void bindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    protected void unbindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        if (this.healthCheckExecutor == healthCheckExecutor) {
            this.healthCheckExecutor = null;
        }
    }
}

