/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.keys.ResourcePathCacheKey;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.util.ParameterUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Extension - ResourceType", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Allowed resource types: [ {httpcache.config.extension.resource-types.allowed} ] Config name: [ {config.name} ]"}), @Property(name="service.ranking", intValue={60})})
@Service
public class ResourceTypeHttpCacheConfigExtension
implements HttpCacheConfigExtension,
CacheKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeHttpCacheConfigExtension.class);
    @Property(label="Allowed paths", description="Regex of content paths that can be cached.", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_PATHS = "httpcache.config.extension.paths.allowed";
    private List<Pattern> pathPatterns;
    @Property(label="Allowed resource types", description="Regex of resource types that can be cached.", unbounded=PropertyUnbounded.ARRAY)
    static final String PROP_RESOURCE_TYPES = "httpcache.config.extension.resource-types.allowed";
    private List<Pattern> resourceTypePatterns;
    @Property(label="Check RT of ./jcr:content?", description="Should the resourceType check be applied to ./jcr:content ?", boolValue={false})
    public static final String PROP_CHECK_CONTENT_RESOURCE_TYPE = "httpcache.config.extension.resource-types.page-content";
    private boolean checkContentResourceType;
    @Property(label="Check resourceSuperType", description="Should the resourceType check check super Types?", boolValue={false})
    static final String PROP_CHECK_RESOURCE_SUPER_TYPE = "httpcache.config.extension.resource-types.superType";
    private boolean checkResourceSuperType;
    @Property(label="Config Name", description="")
    static final String PROP_CONFIG_NAME = "config.name";
    private String configName;

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheRepositoryAccessException {
        if (log.isDebugEnabled()) {
            log.debug("ResourceHttpCacheConfigExtension {} : ResourceType acceptance check on [ {} ~> {} ]", new Object[]{this.configName, request.getResource(), request.getResource().getResourceType()});
        }
        for (Pattern pattern : this.pathPatterns) {
            Matcher m = pattern.matcher(request.getResource().getPath());
            if (m.matches()) continue;
            return false;
        }
        Resource candidateResource = request.getResource();
        if (this.checkContentResourceType && (candidateResource = candidateResource.getChild("jcr:content")) == null) {
            return false;
        }
        log.debug("ResourceHttpCacheConfigExtension {} :  checking for resource type matches", (Object)this.configName);
        return this.checkResourceType(candidateResource);
    }

    private boolean checkResourceType(Resource candidateResource) {
        if (this.checkResourceSuperType) {
            return this.resourceTypePatterns.stream().anyMatch(pattern -> candidateResource.getResourceResolver().isResourceType(candidateResource, pattern.pattern()));
        }
        return this.resourceTypePatterns.stream().anyMatch(pattern -> pattern.matcher(candidateResource.getResourceType()).matches());
    }

    @Override
    public CacheKey build(SlingHttpServletRequest slingHttpServletRequest, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new ResourcePathCacheKey(slingHttpServletRequest, cacheConfig);
    }

    @Override
    public CacheKey build(String resourcePath, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new ResourcePathCacheKey(resourcePath, cacheConfig);
    }

    @Override
    public boolean doesKeyMatchConfig(CacheKey key, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        if (!(key instanceof ResourcePathCacheKey)) {
            return false;
        }
        return new ResourcePathCacheKey(key.getUri(), cacheConfig).equals(key);
    }

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.resourceTypePatterns = ParameterUtil.toPatterns(PropertiesUtil.toStringArray((Object)configs.get(PROP_RESOURCE_TYPES), (String[])new String[0]));
        this.pathPatterns = ParameterUtil.toPatterns(PropertiesUtil.toStringArray((Object)configs.get(PROP_PATHS), (String[])new String[0]));
        this.checkContentResourceType = PropertiesUtil.toBoolean((Object)configs.get(PROP_CHECK_CONTENT_RESOURCE_TYPE), (boolean)false);
        this.checkResourceSuperType = PropertiesUtil.toBoolean((Object)configs.get(PROP_CHECK_RESOURCE_SUPER_TYPE), (boolean)false);
        this.configName = PropertiesUtil.toString((Object)configs.get(PROP_CONFIG_NAME), (String)"");
        log.info("ResourceHttpCacheConfigExtension activated/modified.");
    }
}

