/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl.keys;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.keys.AbstractCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.sling.api.SlingHttpServletRequest;

public class KeyValueCacheKey
extends AbstractCacheKey
implements CacheKey,
Serializable {
    private String cacheKeyId;
    private Map<String, String[]> allowedKeyValues;

    public KeyValueCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, String cacheKeyId, Map<String, String[]> allowedKeyValues) {
        super(request, cacheConfig);
        this.cacheKeyId = cacheKeyId;
        this.allowedKeyValues = allowedKeyValues;
    }

    public KeyValueCacheKey(String uri, HttpCacheConfig cacheConfig, String cacheKeyId, Map<String, String[]> allowedKeyValues) {
        super(uri, cacheConfig);
        this.cacheKeyId = cacheKeyId;
        this.allowedKeyValues = allowedKeyValues;
    }

    Map<String, String[]> getAllowedKeyValues() {
        return this.allowedKeyValues;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        KeyValueCacheKey that = (KeyValueCacheKey)o;
        if (that == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getUri(), (Object)that.getUri()).append((Object)this.cacheKeyId, (Object)that.cacheKeyId).append((Object)this.getAuthenticationRequirement(), (Object)that.getAuthenticationRequirement()).appendSuper(this.getEqualForAllowedKeyValues(that)).isEquals();
    }

    private boolean getEqualForAllowedKeyValues(KeyValueCacheKey other) {
        if (this.allowedKeyValues.size() != other.allowedKeyValues.size()) {
            return false;
        }
        for (Map.Entry<String, String[]> entry : this.allowedKeyValues.entrySet()) {
            String key = entry.getKey();
            Object[] val = entry.getValue();
            if (other.allowedKeyValues.containsKey(key) && Arrays.equals(val, other.allowedKeyValues.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUri()).append((Object)this.cacheKeyId).append((Object)this.getAuthenticationRequirement()).toHashCode();
    }

    @Override
    public String toString() {
        return String.format("%s%s[AUTH_REQ:%s]", this.uri, this.cacheKeyId, this.getAuthenticationRequirement());
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        this.parentWriteObject(o);
        o.writeUTF(this.cacheKeyId);
        o.writeObject(new HashMap<String, String[]>(this.allowedKeyValues));
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        this.parentReadObject(o);
        this.cacheKeyId = o.readUTF();
        this.allowedKeyValues = (Map)o.readObject();
    }
}

