/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.invalidator.event;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - JCR node change invalidator", description="Watches for the configured JCR paths and triggers cache invalidation job.", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="JCR paths to watch for changes. (legacy)", description="Paths expressed in LDAP syntax. Example: (|(path=/content*)(path=/etc*)) - Watches for changes under /content or /etc. This is deprecated - consider using resource.paths instead for better performance.", name="event.filter"), @Property(label="JCR paths to watch for changes.", value={"/content", "/etc"}, description="List of paths to watch. Entries with the 'glob:' prefix are interpreted as globs, i.e. the * and ** wildcards are supported.", name="resource.paths"), @Property(name="webconsole.configurationFactory.nameHint", value={"JCR paths to watch for changes: {event.filter} {resource.paths}"}, propertyPrivate=true)})
public class JCRNodeChangeEventHandler
implements EventHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(JCRNodeChangeEventHandler.class);
    @Reference
    private JobManager jobManager;
    private ServiceRegistration<?> registration;

    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        String pathFilter = PropertiesUtil.toString((Object)config.get("event.filter"), (String)"");
        if (!pathFilter.isEmpty()) {
            log.warn("LDAP-style path filter detected, so a legacy event-based listener will be registered. Consider using a list of paths instead to improve performance.");
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("event.topics", new String[]{"org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/REMOVED"});
            ((Dictionary)properties).put("event.filter", pathFilter);
            this.registration = context.registerService(EventHandler.class, (Object)this, properties);
        } else {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("resource.paths", config.get("resource.paths"));
            this.registration = context.registerService(ResourceChangeListener.class, (Object)this, properties);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.registration.unregister();
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        this.handlePath(path);
    }

    public void onChange(List<ResourceChange> changes) {
        for (ResourceChange change : changes) {
            this.handlePath(change.getPath());
        }
    }

    private void handlePath(String path) {
        Map<String, String> payload = Collections.singletonMap("path", path);
        this.jobManager.addJob("com/adobe/acs/commons/httpcache/invalidator/job", payload);
        log.debug("New invalidation job created with the payload path. - {}", (Object)path);
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }
}

