/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.visitor;

import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.AbstractNodeVisitor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class ExpiredNodesVisitor
extends AbstractNodeVisitor {
    public ExpiredNodesVisitor(int maxLevel, long deltaSaveThreshold) {
        super(maxLevel, deltaSaveThreshold);
    }

    @Override
    protected void leaving(Node node, int level) throws RepositoryException {
        if (ExpiredNodesVisitor.isCacheEntryNode(node)) {
            this.checkNodeForExpiry(node);
        } else if (ExpiredNodesVisitor.isEmptyBucketNode(node)) {
            node.remove();
            this.persistSession();
        }
        super.leaving(node, level);
    }

    private void checkNodeForExpiry(Node node) throws RepositoryException {
        long expiryProperty;
        if (node.hasProperty("expiresOn") && (expiryProperty = node.getProperty("expiresOn").getLong()) < System.currentTimeMillis()) {
            node.remove();
            this.persistSession();
        }
    }
}

