/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.writer;

import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;

public class EntryNodeWriter {
    private final Session session;
    private final Node entryNode;
    private final CacheKey cacheKey;
    private final CacheContent cacheContent;
    private final long expireTimeInMilliSeconds;

    public EntryNodeWriter(Session session, Node entryNode, CacheKey cacheKey, CacheContent cacheContent, long expireTimeInMilliSeconds) {
        this.session = session;
        this.entryNode = entryNode;
        this.cacheKey = cacheKey;
        this.cacheContent = cacheContent;
        this.expireTimeInMilliSeconds = expireTimeInMilliSeconds;
    }

    public void write() throws RepositoryException, IOException {
        this.entryNode.setProperty("isCacheEntryNode", true);
        this.populateMetaData();
        this.populateHeaders();
        this.populateBinaryContent();
        if (this.expireTimeInMilliSeconds > 0L) {
            this.setExpireTime();
        }
        if (!this.entryNode.hasProperty("cacheKeySerialized")) {
            this.populateCacheKey();
        }
    }

    private void setExpireTime() throws RepositoryException {
        this.entryNode.setProperty("expiresOn", this.expireTimeInMilliSeconds + System.currentTimeMillis());
    }

    private void populateMetaData() throws RepositoryException {
        this.entryNode.setProperty("status", (long)this.cacheContent.getStatus());
        this.entryNode.setProperty("char-encoding", this.cacheContent.getCharEncoding());
        this.entryNode.setProperty("content-type", this.cacheContent.getContentType());
        this.entryNode.setProperty("responseWriteMethod", this.cacheContent.getWriteMethod().name());
    }

    private void populateBinaryContent() throws RepositoryException {
        Node contents = this.getOrCreateByPath(this.entryNode, "contents", "nt:file", "nt:file");
        Node jcrContent = this.getOrCreateByPath(contents, "jcr:content", "nt:resource", "nt:resource");
        Binary binary = this.session.getValueFactory().createBinary(this.cacheContent.getInputDataStream());
        jcrContent.setProperty("jcr:data", binary);
        jcrContent.setProperty("jcr:mimeType", this.cacheContent.getContentType());
    }

    private void populateHeaders() throws RepositoryException {
        Node headers = this.getOrCreateByPath(this.entryNode, "headers", "oak:Unstructured", "oak:Unstructured");
        for (Map.Entry<String, List<String>> entry : this.cacheContent.getHeaders().entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            headers.setProperty(key, values.toArray(new String[values.size()]));
        }
    }

    protected Node getOrCreateByPath(Node baseNode, String path, String intermediateNodeType, String nodeType) throws RepositoryException {
        return JcrUtils.getOrCreateByPath((Node)baseNode, (String)path, (boolean)false, (String)intermediateNodeType, (String)nodeType, (boolean)false);
    }

    private void populateCacheKey() throws RepositoryException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.cacheKey);
        objectOutputStream.close();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
            Binary binary = this.session.getValueFactory().createBinary((InputStream)inputStream);
            this.entryNode.setProperty("cacheKeySerialized", binary);
        }
    }
}

