/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.Description;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class RadioComponent
extends FieldComponent {
    private static final String DESCRIPTION_DELIMITER = "::";

    @Override
    public void init() {
        this.setResourceType("granite/ui/components/foundation/form/radiogroup");
        this.getComponentMetadata().put("vertical", (Object)this.hasOption("vertical"));
        this.getComponentMetadata().put("text", (Object)this.getFieldDefinition().name());
        this.getComponentMetadata().remove((Object)"fieldLabel");
        this.getComponentMetadata().remove((Object)"fieldDescription");
    }

    @Override
    public Resource buildComponentResource() {
        AbstractResourceImpl component = (AbstractResourceImpl)super.buildComponentResource();
        AbstractResourceImpl options = new AbstractResourceImpl("items", null, null, new ResourceMetadata());
        component.addChild((Resource)options);
        String defaultValue = this.getOption("default").orElse(null);
        this.getOptions().forEach((value, name) -> {
            ResourceMetadata meta = new ResourceMetadata();
            String nodeName = JcrUtil.escapeIllegalJcrChars((String)value);
            if (value.equals(defaultValue)) {
                meta.put("checked", (Object)true);
            }
            meta.put("name", (Object)this.getName());
            meta.put("value", value);
            if (name.contains(DESCRIPTION_DELIMITER)) {
                String description = StringUtils.substringAfter((String)name, (String)DESCRIPTION_DELIMITER);
                meta.put("title", (Object)description);
                name = StringUtils.substringBefore((String)name, (String)DESCRIPTION_DELIMITER);
            }
            meta.put("text", name);
            AbstractResourceImpl option = new AbstractResourceImpl("option_" + nodeName, "granite/ui/components/foundation/form/radio", "granite/ui/components/foundation/form/field", meta);
            options.addChild((Resource)option);
        });
        return component;
    }

    public abstract Map<String, String> getOptions();

    public static class EnumerationSelector
    extends RadioComponent {
        @Override
        public Map<String, String> getOptions() {
            return Stream.of((Enum[])this.getField().getType().getEnumConstants()).collect(Collectors.toMap(Enum::name, this::getName, (k, v) -> {
                throw new IllegalArgumentException("cannot merge");
            }, LinkedHashMap::new));
        }

        private String getName(Enum e) {
            String name = StringUtil.getFriendlyName(e.name());
            try {
                Description desc = e.getClass().getField(e.name()).getAnnotation(Description.class);
                if (desc != null) {
                    name = name + RadioComponent.DESCRIPTION_DELIMITER + desc.value();
                }
            }
            catch (NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(RadioComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
            return name;
        }
    }
}

