/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.mcp.DialogResourceProviderConfiguration;
import com.adobe.acs.commons.mcp.DialogResourceProviderFactory;
import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.impl.DialogResourceProviderImpl;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DialogResourceProviderFactory.class}, immediate=true)
@Designate(ocd=DialogResourceProviderConfiguration.class)
public class DialogResourceProviderFactoryImpl
implements DialogResourceProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DialogResourceProviderFactoryImpl.class);
    private static final String IMPLEMENTATION_CLASS = "models.adapter.implementationClass";
    private final Map<String, ServiceRegistration<ResourceProvider>> resourceProviderRegistrations = Collections.synchronizedMap(new HashMap());
    private final Set<String> allKnownModels = Collections.synchronizedSet(new HashSet());
    private final String[] ignoredPackages = new String[]{"com.adobe.cq.", "com.adobe.aemds.", "com.adobe.fd.ccm.", "com.adobe.forms.", "com.adobe.granite.", "com.day.cq.", "we.retail."};
    @Reference(service=AdapterFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="bind", unbind="unbind")
    volatile List<AdapterFactory> adapterFactory;
    volatile BundleContext bundleContext;
    private boolean enabled = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void bind(AdapterFactory adapterFactory, Map<String, ?> properties) {
        this.getModelClass(properties).ifPresent(this::registerClass);
    }

    public void unbind(AdapterFactory adapterFactory, Map<String, ?> properties) {
        this.getModelClass(properties).ifPresent(this::unregisterClass);
    }

    @Activate
    public void activate(BundleContext context, DialogResourceProviderConfiguration config) {
        this.bundleContext = context;
        this.setEnabled(config != null && config.enabled());
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
        if (this.isEnabled()) {
            this.allKnownModels.forEach(this::registerClass);
        } else {
            this.deactivate();
        }
    }

    @Deactivate
    public void deactivate() {
        this.allKnownModels.forEach(this::unregisterClass);
        this.resourceProviderRegistrations.clear();
    }

    private Optional<String> getModelClass(Map<String, ?> properties) {
        if (properties != null && properties.containsKey(IMPLEMENTATION_CLASS)) {
            return Optional.of(String.valueOf(properties.get(IMPLEMENTATION_CLASS)));
        }
        return Optional.empty();
    }

    private Optional<Class> getClassIfAvailable(String className) {
        for (String ignored : this.ignoredPackages) {
            if (!className.startsWith(ignored)) continue;
            return Optional.empty();
        }
        Class clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            for (Bundle bundle : FrameworkUtil.getBundle(this.getClass()).getBundleContext().getBundles()) {
                try {
                    clazz = bundle.loadClass(className);
                    return Optional.of(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            LOG.debug(String.format("COULD NOT RESOLVE CLASS %s", className));
        }
        return Optional.ofNullable(clazz);
    }

    @Override
    public void registerClass(String className) {
        this.getClassIfAvailable(className).ifPresent(this::registerClass);
    }

    @Override
    public void registerClass(Class c) {
        this.allKnownModels.add(c.getName());
        if (this.isEnabled() && this.isDialogProvider(c)) {
            this.unregisterClass(c);
            DialogResourceProviderImpl provider = null;
            try {
                provider = new DialogResourceProviderImpl(c, this.getDialogProviderAnnotation(c).orElse(null));
                this.resourceProviderRegistrations.put(c.getName(), this.registerResourceProvider(provider));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Error when registering resource provider", (Throwable)e);
            }
        }
    }

    private ServiceRegistration<ResourceProvider> registerResourceProvider(DialogResourceProviderImpl provider) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("provider.name", provider.getRoot());
        ((Dictionary)props).put("provider.root", provider.getRoot());
        ((Dictionary)props).put("provider.useResourceAccessSecurity", Boolean.FALSE);
        LOG.debug(String.format("Registering at path %s", provider.getRoot()));
        return this.bundleContext.registerService(ResourceProvider.class, (Object)provider, props);
    }

    @Override
    public void unregisterClass(Class c) {
        this.unregisterClass(c.getName());
    }

    @Override
    public void unregisterClass(String c) {
        ServiceRegistration<ResourceProvider> serviceRegistration = this.resourceProviderRegistrations.remove(c);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    @Override
    public Map<String, ServiceRegistration<ResourceProvider>> getActiveProviders() {
        return Collections.unmodifiableMap(this.resourceProviderRegistrations);
    }

    private boolean isDialogProvider(Class c) {
        return this.getDialogProviderAnnotation(c).isPresent();
    }

    private Optional<DialogProvider> getDialogProviderAnnotation(Class c) {
        return StreamSupport.stream(ClassUtils.hierarchy((Class)c, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE).spliterator(), false).filter(clazz -> clazz.isAnnotationPresent(DialogProvider.class)).findFirst().map(clazz -> clazz.getAnnotation(DialogProvider.class));
    }
}

