/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.mcp.model.GenericReport;
import com.day.cq.commons.jcr.JcrUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"acs-commons/components/utilities/process-instance/process-generic-report"}, extensions={"xlsx", "xls"})
public class GenericReportExcelServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(GenericReportExcelServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block15: {
            GenericReport report = (GenericReport)request.getResource().adaptTo(GenericReport.class);
            if (report != null) {
                String title = report.getName();
                String fileName = JcrUtil.createValidName((String)title) + ".xlsx";
                Workbook workbook = this.createSpreadsheet(report);
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Expires", "0");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Pragma", "public");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                try (ServletOutputStream out = response.getOutputStream();){
                    workbook.write((OutputStream)out);
                    out.flush();
                    break block15;
                }
                catch (Exception ex) {
                    LOG.error("Error generating excel export for " + request.getResource().getPath(), (Throwable)ex);
                    throw ex;
                }
            }
            LOG.error("Unable to process report stored at " + request.getResource().getPath());
            throw new ServletException("Unable to process report stored at " + request.getResource().getPath());
        }
    }

    private Workbook createSpreadsheet(GenericReport report) {
        XSSFWorkbook wb = new XSSFWorkbook();
        String name = report.getName();
        for (char ch : new char[]{'\\', '/', '*', '[', ']', ':', '?'}) {
            name = StringUtils.remove((String)name, (char)ch);
        }
        Sheet sheet = wb.createSheet(name);
        sheet.createFreezePane(0, 1, 0, 1);
        Row headerRow = sheet.createRow(0);
        CellStyle headerStyle = this.createHeaderStyle((Workbook)wb);
        for (int c = 0; c < report.getColumnNames().size(); ++c) {
            Cell headerCell = headerRow.createCell(c);
            headerCell.setCellValue(report.getColumnNames().get(c));
            headerCell.setCellStyle(headerStyle);
        }
        List<ValueMap> rows = report.getRows();
        for (int r = 0; r < rows.size(); ++r) {
            Row row = sheet.createRow(r + 1);
            for (int c = 0; c < report.getColumns().size(); ++c) {
                String col = report.getColumns().get(c);
                Cell cell = row.createCell(c);
                if (!rows.get(r).containsKey((Object)col)) continue;
                Object val = rows.get(r).get((Object)col);
                if (val instanceof Number) {
                    Number n = (Number)val;
                    cell.setCellValue(n.doubleValue());
                    continue;
                }
                String sval = String.valueOf(val);
                if (sval.startsWith("=")) {
                    cell.setCellFormula(sval.substring(1));
                    continue;
                }
                cell.setCellValue(sval);
            }
        }
        int lastColumnIndex = report.getColumnNames().size();
        this.autosize(sheet, lastColumnIndex);
        sheet.setAutoFilter(new CellRangeAddress(0, 1 + rows.size(), 0, lastColumnIndex - 1));
        return wb;
    }

    CellStyle createHeaderStyle(Workbook wb) {
        XSSFCellStyle xstyle = (XSSFCellStyle)wb.createCellStyle();
        XSSFColor header = new XSSFColor(new Color(79, 129, 189));
        xstyle.setFillForegroundColor(header);
        xstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setColor(IndexedColors.WHITE.index);
        xstyle.setFont((Font)font);
        return xstyle;
    }

    void autosize(Sheet sheet, int lastColumnIndex) {
        for (int i = 0; i <= lastColumnIndex; ++i) {
            try {
                sheet.autoSizeColumn(i);
            }
            catch (Exception e) {
                LOG.warn("autoSizeColumn(" + i + ") failed: " + e.getMessage());
            }
            int cw = sheet.getColumnWidth(i);
            if (cw / 256 < 20) {
                sheet.setColumnWidth(i, 3072);
                continue;
            }
            if (cw / 256 <= 120) continue;
            sheet.setColumnWidth(i, 30720);
        }
    }
}

