/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.actions.ActionBatch;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.mcp.ControlledProcessManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.model.ManagedProcess;
import com.adobe.acs.commons.mcp.model.Result;
import com.adobe.acs.commons.mcp.model.impl.ArchivedProcessFailure;
import com.adobe.acs.commons.mcp.util.DeserializeException;
import com.adobe.acs.commons.mcp.util.ValueMapSerializer;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceImpl
implements ProcessInstance,
Serializable {
    private static final long serialVersionUID = 7526472295622776151L;
    private final ManagedProcess infoBean;
    private final String id;
    private final String path;
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessInstanceImpl.class);
    private final transient List<ActivityDefinition> actions;
    public static final transient String BASE_PATH = "/var/acs-commons/mcp/instances";
    private transient ControlledProcessManager manager = null;
    private final transient ProcessDefinition definition;
    private transient boolean completedNormally = false;
    private static final transient Random RANDOM = new Random();
    private static String[] statsItemNames;
    private static CompositeType statsCompositeType;
    private static TabularType statsTabularType;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public double updateProgress() {
        double sectionWeight = 1.0 / (double)this.actions.size();
        double progress = this.actions.stream().map(action -> action.manager).filter(action -> action.getAddedCount() > 0).collect(Collectors.summingDouble(action -> sectionWeight * (double)action.getCompletedCount() / (double)action.getAddedCount()));
        this.infoBean.setProgress(progress);
        this.infoBean.setStatus(this.actions.stream().filter(a -> !a.manager.isComplete()).map(a -> a.name).findFirst().orElse("Please wait..."));
        int countCompleted = this.actions.stream().collect(Collectors.summingInt(action -> action.manager.getCompletedCount()));
        this.infoBean.getResult().setTasksCompleted(Math.max(this.infoBean.getResult().getTasksCompleted(), countCompleted));
        this.infoBean.setReportedErrors(this.actions.stream().flatMap(a -> a.manager.getFailureList().stream()).map(ArchivedProcessFailure::adapt).collect(Collectors.toList()));
        return progress;
    }

    public ProcessInstanceImpl(ControlledProcessManager cpm, ProcessDefinition process, String description) {
        this.manager = cpm;
        this.infoBean = new ManagedProcess();
        this.infoBean.setStartTime(-1L);
        this.infoBean.setStopTime(-1L);
        this.actions = new ArrayList<ActivityDefinition>();
        this.definition = process;
        this.infoBean.setName(process.getName());
        this.infoBean.setDescription(description == null ? "No description" : description);
        this.infoBean.setResult(new Result());
        this.id = String.format("%016X", Math.abs(RANDOM.nextLong()));
        this.path = "/var/acs-commons/mcp/instances/" + this.id;
    }

    @Override
    public String getName() {
        if (this.definition.getName() != null) {
            if (this.infoBean.getDescription() != null) {
                return this.definition.getName() + ": " + this.infoBean.getDescription();
            }
            return this.definition.getName();
        }
        if (this.infoBean.getDescription() != null) {
            return this.infoBean.getDescription();
        }
        return "No idea";
    }

    @Override
    public void init(ResourceResolver resourceResolver, Map<String, Object> parameterMap) throws DeserializeException, RepositoryException {
        try {
            ModifiableValueMapDecorator inputs = new ModifiableValueMapDecorator(parameterMap);
            this.infoBean.setRequestInputs((ValueMap)inputs);
            this.definition.parseInputs((ValueMap)inputs);
        }
        catch (DeserializeException | RepositoryException ex) {
            LOG.error("Error starting managed process " + this.getName(), ex);
            Failure f = new Failure();
            f.setException((Exception)ex);
            f.setNodePath(this.getPath());
            this.recordErrors(-1, Arrays.asList(f), resourceResolver);
            this.halt();
            throw ex;
        }
    }

    @Override
    public ActionManagerFactory getActionManagerFactory() {
        return this.manager.getActionManagerFactory();
    }

    @Override
    public final ActionManager defineCriticalAction(String name, ResourceResolver rr, CheckedConsumer<ActionManager> builder) throws LoginException {
        return this.defineAction(name, rr, builder, true);
    }

    @Override
    public final ActionManager defineAction(String name, ResourceResolver rr, CheckedConsumer<ActionManager> builder) throws LoginException {
        return this.defineAction(name, rr, builder, false);
    }

    private ActionManager defineAction(String name, ResourceResolver rr, CheckedConsumer<ActionManager> builder, boolean isCritical) throws LoginException {
        ActivityDefinition activityDefinition = new ActivityDefinition();
        activityDefinition.builder = builder;
        activityDefinition.name = name;
        activityDefinition.manager = this.getActionManagerFactory().createTaskManager(this.getName() + ": " + name, rr, 1);
        activityDefinition.critical = isCritical;
        this.actions.add(activityDefinition);
        return activityDefinition.manager;
    }

    @Override
    public final void run(ResourceResolver rr) {
        try {
            this.infoBean.setRequester(rr.getUserID());
            this.infoBean.setStartTime(System.currentTimeMillis());
            this.definition.buildProcess(this, rr);
            this.infoBean.setIsRunning(true);
            this.runStep(0);
        }
        catch (RuntimeException | RepositoryException | LoginException ex) {
            LOG.error("Error starting managed process " + this.getName(), ex);
            Failure f = new Failure();
            f.setException((Exception)ex);
            f.setNodePath(this.getPath());
            this.asServiceUser(serviceResolver -> {
                this.persistStatus((ResourceResolver)serviceResolver);
                this.recordErrors(-1, Arrays.asList(f), (ResourceResolver)serviceResolver);
            });
            this.halt();
        }
    }

    private void runStep(int step) {
        if (step >= this.actions.size()) {
            this.completedNormally = true;
            this.halt();
        } else {
            this.updateProgress();
            this.updateStatus(step);
            this.asServiceUser(this::persistStatus);
            ActivityDefinition action = this.actions.get(step);
            if (action.critical) {
                action.manager.onSuccess(rr -> this.runStep(step + 1));
                action.manager.onFailure((failures, rr) -> {
                    this.asServiceUser(service -> this.recordErrors(step, (List<Failure>)failures, (ResourceResolver)service));
                    this.halt();
                });
            } else {
                action.manager.onFailure((failures, rr) -> this.asServiceUser(service -> this.recordErrors(step, (List<Failure>)failures, (ResourceResolver)service)));
                action.manager.onFinish(() -> this.runStep(step + 1));
            }
            action.manager.deferredWithResolver(rr -> action.builder.accept(action.manager));
        }
    }

    public void recordErrors(int step, List<Failure> failures, ResourceResolver rr) {
        if (failures.isEmpty()) {
            return;
        }
        List<ArchivedProcessFailure> archivedFailures = failures.stream().map(ArchivedProcessFailure::adapt).collect(Collectors.toList());
        this.infoBean.setReportedErrors(archivedFailures);
        try {
            String errFolder = this.getPath() + "/jcr:content/failures/step" + (step + 1);
            JcrUtil.createPath((String)errFolder, (String)"nt:unstructured", (Session)((Session)rr.adaptTo(Session.class)));
            if (rr.hasChanges()) {
                rr.commit();
            }
            rr.refresh();
            ActionManager errorManager = this.getActionManagerFactory().createTaskManager("Record errors", rr, 1);
            ActionBatch batch = new ActionBatch(errorManager, 50);
            for (int i = 0; i < failures.size(); ++i) {
                String errPath = errFolder + "/err" + i;
                Failure failure = failures.get(i);
                batch.add(rr2 -> {
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    ValueMapSerializer.serializeToMap(values, failure);
                    ResourceUtil.getOrCreateResource((ResourceResolver)rr2, (String)errPath, values, null, (boolean)false);
                });
            }
            batch.commitBatch();
        }
        catch (NullPointerException | RepositoryException | LoginException | PersistenceException ex) {
            LOG.error("Unable to record errors", ex);
        }
    }

    private long getRuntime() {
        long stop = System.currentTimeMillis();
        if (this.infoBean.getStopTime() > this.infoBean.getStartTime()) {
            stop = this.infoBean.getStopTime();
        }
        return stop - this.infoBean.getStartTime();
    }

    private void updateStatus(int step) {
        this.infoBean.setStatus("Step " + (step + 1) + ": " + this.actions.get((int)step).name);
    }

    private void setStatusCompleted() {
        this.infoBean.setStatus("Completed");
        this.infoBean.setProgress(1.0);
    }

    private void setStatusAborted() {
        this.infoBean.setStatus("Aborted");
    }

    public void asServiceUser(CheckedConsumer<ResourceResolver> action) {
        try (ResourceResolver rr = this.manager.getServiceResourceResolver();){
            action.accept(rr);
            if (rr.hasChanges()) {
                rr.commit();
            }
        }
        catch (Exception ex) {
            LOG.error("Error while performing JCR operations", (Throwable)ex);
        }
    }

    public void persistStatus(ResourceResolver rr) throws PersistenceException {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("jcr:primaryType", "nt:folder");
            ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)BASE_PATH, props, null, (boolean)true);
            props.put("jcr:primaryType", "cq:Page");
            ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)this.getPath(), props, null, (boolean)true);
            ModifiableValueMap jcrContent = (ModifiableValueMap)ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)(this.getPath() + "/jcr:content"), (String)"acs-commons/components/utilities/process-instance", null, (boolean)false).adaptTo(ModifiableValueMap.class);
            jcrContent.put((Object)"jcr:primaryType", (Object)"cq:PageContent");
            jcrContent.put((Object)"jcr:title", (Object)this.getName());
            ValueMapSerializer.serializeToMap((Map<String, Object>)jcrContent, this.infoBean);
            ModifiableValueMap resultNode = (ModifiableValueMap)ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)(this.getPath() + "/jcr:content/result"), (String)"acs-commons/components/utilities/process-instance/result", null, (boolean)false).adaptTo(ModifiableValueMap.class);
            resultNode.put((Object)"jcr:primaryType", (Object)"nt:unstructured");
            ValueMapSerializer.serializeToMap((Map<String, Object>)resultNode, this.infoBean.getResult());
            rr.commit();
            rr.refresh();
        }
        catch (NullPointerException ex) {
            throw new PersistenceException("Null encountered when persisting status", (Throwable)ex);
        }
    }

    @Override
    public ManagedProcess getInfo() {
        return this.infoBean;
    }

    @Override
    public final void halt() {
        this.updateProgress();
        this.infoBean.setStopTime(System.currentTimeMillis());
        this.infoBean.getResult().setRuntime(this.infoBean.getStopTime() - this.infoBean.getStartTime());
        this.infoBean.setIsRunning(false);
        if (this.completedNormally) {
            this.setStatusCompleted();
        } else {
            this.setStatusAborted();
        }
        this.asServiceUser(rr -> {
            this.persistStatus((ResourceResolver)rr);
            this.definition.storeReport(this, (ResourceResolver)rr);
        });
        this.actions.stream().map(a -> a.manager).forEach(this.getActionManagerFactory()::purge);
        this.manager.purgeCompletedProcesses();
    }

    public static TabularType getStaticsTableType() {
        return statsTabularType;
    }

    @Override
    public CompositeData getStatistics() {
        try {
            return new CompositeDataSupport(statsCompositeType, statsItemNames, new Object[]{this.id, this.getName(), this.actions.size(), this.actions.stream().filter(a -> a.manager.isComplete()).collect(Collectors.counting()), this.actions.stream().map(a -> a.manager.getSuccessCount()).collect(Collectors.summingInt(Integer::intValue)), this.actions.stream().map(a -> a.manager.getErrorCount()).collect(Collectors.summingInt(Integer::intValue)), this.getRuntime(), this.updateProgress()});
        }
        catch (OpenDataException ex) {
            LOG.error("Error building output summary", (Throwable)ex);
            return null;
        }
    }

    static {
        try {
            statsItemNames = new String[]{"_id", "_taskName", "started", "completed", "successful", "errors", "runtime", "pct_complete"};
            statsCompositeType = new CompositeType("Statics Row", "Single row of statistics", statsItemNames, new String[]{"ID", "Name", "Started", "Completed", "Successful", "Errors", "Runtime", "Percent complete"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DOUBLE});
            statsTabularType = new TabularType("Statistics", "Collected statistics", statsCompositeType, new String[]{"_id"});
        }
        catch (OpenDataException ex) {
            LOG.error("Unable to build MBean composite types", (Throwable)ex);
        }
    }

    private static class ActivityDefinition {
        String name;
        ActionManager manager;
        transient CheckedConsumer<ActionManager> builder;
        boolean critical = false;

        private ActivityDefinition() {
        }
    }
}

