/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import acscommons.com.jcraft.jsch.ChannelSftp;
import acscommons.com.jcraft.jsch.JSch;
import acscommons.com.jcraft.jsch.JSchException;
import acscommons.com.jcraft.jsch.SftpATTRS;
import acscommons.com.jcraft.jsch.SftpException;
import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.functions.CheckedSupplier;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PasswordComponent;
import com.adobe.acs.commons.mcp.impl.processes.asset.AssetIngestor;
import com.adobe.acs.commons.mcp.impl.processes.asset.HierarchicalElement;
import com.adobe.acs.commons.mcp.impl.processes.asset.Source;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;

public class FileAssetIngestor
extends AssetIngestor {
    @FormField(name="Source", description="Source folder for content ingestion which can be a local folder or SFTP url", hint="/var/mycontent, /mnt/all_the_things, sftp://host[:port]/base/path...")
    String fileBasePath;
    @FormField(name="Connection timeout", description="Connection timeout (in milliseconds) for SFTP connection", required=false, options={"default=30000"})
    int timeout = 30000;
    @FormField(name="Username", description="Username for SFTP connection", required=false)
    String username = null;
    @FormField(name="Password", description="Password for SFTP connection", required=false, component=PasswordComponent.class)
    String password = null;
    HierarchicalElement baseFolder;

    public FileAssetIngestor(MimeTypeService mimeTypeService) {
        super(mimeTypeService);
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.baseFolder = this.getBaseFolder(this.fileBasePath);
        instance.getInfo().setDescription(this.fileBasePath + "->" + this.jcrBasePath);
        instance.defineCriticalAction("Create Folders", rr, this::createFolders);
        instance.defineCriticalAction("Import Assets", rr, this::importAssets);
    }

    HierarchicalElement getBaseFolder(String url) throws RepositoryException {
        HierarchicalElement baseHierarchicalElement;
        if (url.toLowerCase().startsWith("sftp://")) {
            try {
                baseHierarchicalElement = new SftpHierarchicalElement(url);
                ((SftpHierarchicalElement)baseHierarchicalElement).retrieveDetails();
            }
            catch (UnsupportedEncodingException | URISyntaxException ex) {
                Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                throw new RepositoryException("Unable to process URL!", (Throwable)ex);
            }
            catch (JSchException | SftpException ex) {
                Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                throw new RepositoryException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            File base = new File(url);
            if (!base.exists()) {
                throw new RepositoryException("Source folder does not exist!");
            }
            baseHierarchicalElement = new FileHierarchicalElement(base);
        }
        return baseHierarchicalElement;
    }

    void createFolders(ActionManager manager) throws IOException {
        manager.deferredWithResolver(r -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)r.adaptTo(Session.class)), (boolean)true);
            manager.setCurrentItem(this.fileBasePath);
            this.baseFolder.visitAllFolders(folder -> {
                if (this.canImportFolder((HierarchicalElement)folder)) {
                    manager.deferredWithResolver(Actions.retry(this.retries, this.retryPause, rr -> {
                        manager.setCurrentItem(folder.getSourcePath());
                        this.createFolderNode((HierarchicalElement)folder, (ResourceResolver)rr);
                    }));
                }
            });
        });
    }

    void importAssets(ActionManager manager) throws IOException {
        manager.deferredWithResolver(rr -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)rr.adaptTo(Session.class)), (boolean)true);
            manager.setCurrentItem(this.fileBasePath);
            this.baseFolder.visitAllFiles(file -> {
                Source fileSource;
                if (this.canImportContainingFolder((HierarchicalElement)file) && this.canImportFile(fileSource = file.getSource())) {
                    this.addFileImportTask(fileSource, manager);
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileImportTask(Source fileSource, ActionManager manager) {
        Failure failure;
        try {
            if (this.canImportFile(fileSource)) {
                manager.deferredWithResolver(Actions.retry(this.retries, this.retryPause, this.importAsset(fileSource, manager)));
            } else {
                this.incrementCount(this.skippedFiles, 1L);
                this.trackDetailedActivity(fileSource.getName(), "Skip", "Skipping file", 0L);
            }
        }
        catch (IOException ex) {
            failure = new Failure();
            failure.setException(ex);
            failure.setNodePath(fileSource.getElement().getNodePath(this.preserveFileName));
            manager.getFailureList().add(failure);
        }
        finally {
            try {
                fileSource.close();
            }
            catch (IOException ex) {
                failure = new Failure();
                failure.setException(ex);
                failure.setNodePath(fileSource.getElement().getNodePath(this.preserveFileName));
                manager.getFailureList().add(failure);
            }
        }
    }

    public static class SftpSource
    implements Source {
        Long length;
        CheckedSupplier<ChannelSftp> channel;
        InputStream lastStream;
        ChannelSftp lastChannel;
        HierarchicalElement element;

        public SftpSource(long length, CheckedSupplier<ChannelSftp> channel, HierarchicalElement elem) {
            this.channel = channel;
            this.length = length;
            this.element = elem;
        }

        @Override
        public String getName() {
            return this.element.getName();
        }

        @Override
        public InputStream getStream() throws IOException {
            try {
                this.lastChannel = this.channel.get();
                this.lastStream = this.lastChannel.get(this.element.getItemName());
            }
            catch (Exception ex) {
                Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                this.close();
                throw new IOException("Error in retrieving file " + this.element.getItemName(), ex);
            }
            return this.lastStream;
        }

        @Override
        public long getLength() throws IOException {
            return this.length;
        }

        @Override
        public HierarchicalElement getElement() {
            return this.element;
        }

        @Override
        public void close() throws IOException {
            if (this.lastStream != null) {
                this.lastStream.close();
                this.lastStream = null;
            }
            if (this.lastChannel != null) {
                this.lastChannel.disconnect();
                try {
                    this.lastChannel.getSession().disconnect();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
                this.lastChannel = null;
            }
        }
    }

    class SftpHierarchicalElement
    implements HierarchicalElement {
        boolean isFile;
        HierarchicalElement parent;
        String path;
        ChannelSftp channel;
        boolean retrieved = false;
        URI uri;
        String sourcePath;
        long size;
        Source source;
        boolean keepChannelOpen = false;

        SftpHierarchicalElement(String uri) throws URISyntaxException, UnsupportedEncodingException {
            this.sourcePath = uri;
            this.uri = new URI(HierarchicalElement.UriHelper.encodeUriParts(uri));
            this.path = HierarchicalElement.UriHelper.decodeUriParts(this.uri.getRawPath());
        }

        SftpHierarchicalElement(String uri, ChannelSftp channel, boolean holdOpen) throws URISyntaxException, UnsupportedEncodingException {
            this(uri);
            this.channel = channel;
            this.keepChannelOpen = holdOpen;
        }

        @Override
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public boolean excludeBaseFolder() {
            return this.getParent() == null && this.isFolder();
        }

        private ChannelSftp openChannel() throws JSchException {
            if (this.channel == null || !this.channel.isConnected()) {
                JSch jsch = new JSch();
                int port = this.uri.getPort() <= 0 ? 22 : this.uri.getPort();
                acscommons.com.jcraft.jsch.Session session = jsch.getSession(FileAssetIngestor.this.username, this.uri.getHost(), port);
                session.setConfig("StrictHostKeyChecking", "no");
                session.setTimeout(FileAssetIngestor.this.timeout);
                session.setPassword(FileAssetIngestor.this.password);
                session.connect();
                this.channel = (ChannelSftp)session.openChannel("sftp");
                this.channel.connect();
                this.keepChannelOpen = false;
            }
            return this.channel;
        }

        private void closeChannel() {
            if (this.channel != null) {
                this.channel.disconnect();
                try {
                    this.channel.getSession().disconnect();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            this.channel = null;
        }

        private void retrieveDetails() throws JSchException, SftpException {
            if (!this.retrieved) {
                try {
                    this.openChannel();
                    SftpATTRS attributes = this.channel.lstat(this.path);
                    this.processAttrs(attributes);
                }
                catch (JSchException | SftpException ex) {
                    Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                    throw ex;
                }
                finally {
                    if (!this.keepChannelOpen) {
                        this.closeChannel();
                    }
                }
            }
        }

        private void processAttrs(SftpATTRS attrs) {
            this.isFile = !attrs.isDir();
            this.size = attrs.getSize();
            this.retrieved = true;
        }

        @Override
        public boolean isFile() {
            try {
                this.retrieveDetails();
            }
            catch (JSchException | SftpException ex) {
                Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
            }
            return this.isFile;
        }

        @Override
        public HierarchicalElement getParent() {
            if (this.parent == null && !FileAssetIngestor.this.fileBasePath.equals(this.getSourcePath())) {
                try {
                    this.parent = new SftpHierarchicalElement(StringUtils.substringBeforeLast((String)this.getSourcePath(), (String)"/"));
                }
                catch (UnsupportedEncodingException | URISyntaxException ex) {
                    Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return this.parent;
        }

        @Override
        public Stream<HierarchicalElement> getChildren() {
            try {
                this.openChannel();
                Vector children = this.channel.ls(this.path);
                Stream<HierarchicalElement> stream = children.stream().filter(this::isNotDotFolder).map(this::getChildFromEntry).filter(Objects::nonNull);
                return stream;
            }
            catch (JSchException | SftpException ex) {
                Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                Stream<HierarchicalElement> stream = Stream.empty();
                return stream;
            }
            finally {
                if (!this.keepChannelOpen) {
                    this.closeChannel();
                }
            }
        }

        private boolean isNotDotFolder(ChannelSftp.LsEntry entry) {
            return !".".equals(entry.getFilename()) && !"..".equals(entry.getFilename());
        }

        private HierarchicalElement getChildFromEntry(ChannelSftp.LsEntry entry) {
            try {
                String childPath = this.getSourcePath() + "/" + entry.getFilename();
                SftpHierarchicalElement child = new SftpHierarchicalElement(childPath, this.channel, true);
                child.processAttrs(entry.getAttrs());
                return child;
            }
            catch (UnsupportedEncodingException | URISyntaxException ex) {
                Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        @Override
        public String getName() {
            return StringUtils.substringAfterLast((String)this.path, (String)"/");
        }

        @Override
        public String getItemName() {
            return this.path;
        }

        @Override
        public Source getSource() {
            if (this.source == null) {
                try {
                    this.retrieveDetails();
                    this.source = new SftpSource(this.size, this::openChannel, this);
                }
                catch (JSchException | SftpException ex) {
                    Logger.getLogger(FileAssetIngestor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return this.source;
        }

        @Override
        public String getJcrBasePath() {
            return FileAssetIngestor.this.jcrBasePath;
        }
    }

    class FileHierarchicalElement
    implements HierarchicalElement {
        final File file;

        FileHierarchicalElement(File f) {
            this.file = f;
        }

        @Override
        public String getSourcePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean excludeBaseFolder() {
            return this.getParent() == null && this.isFolder();
        }

        @Override
        public Source getSource() {
            return new FileSource(this.file, this);
        }

        @Override
        public String getItemName() {
            return this.file.getPath();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public HierarchicalElement getParent() {
            File parent = this.file.getParentFile();
            if (parent == null || this.file.getAbsolutePath().equals(FileAssetIngestor.this.fileBasePath)) {
                return null;
            }
            return new FileHierarchicalElement(this.file.getParentFile());
        }

        @Override
        public boolean isFolder() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public String getJcrBasePath() {
            return FileAssetIngestor.this.jcrBasePath;
        }

        @Override
        public Stream<HierarchicalElement> getChildren() {
            return Stream.of(this.file.listFiles()).map(x$0 -> new FileHierarchicalElement((File)x$0));
        }
    }

    private class FileSource
    implements Source {
        final File file;
        final HierarchicalElement element;
        private InputStream lastOpenStream;

        private FileSource(File f, FileHierarchicalElement el) {
            this.file = f;
            this.element = el;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public InputStream getStream() throws IOException {
            this.close();
            this.lastOpenStream = new FileInputStream(this.file);
            return this.lastOpenStream;
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public HierarchicalElement getElement() {
            return this.element;
        }

        @Override
        public void close() throws IOException {
            if (this.lastOpenStream != null) {
                this.lastOpenStream.close();
            }
            this.lastOpenStream = null;
        }
    }
}

