/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import acscommons.com.jcraft.jsch.Channel;
import acscommons.com.jcraft.jsch.ChannelSftp;
import acscommons.com.jcraft.jsch.JSch;
import acscommons.com.jcraft.jsch.JSchException;
import acscommons.com.jcraft.jsch.Session;
import acscommons.com.jcraft.jsch.SftpATTRS;
import acscommons.com.jcraft.jsch.SftpException;
import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.mcp.impl.processes.asset.ClientProvider;
import com.adobe.acs.commons.mcp.impl.processes.asset.Folder;
import com.adobe.acs.commons.mcp.impl.processes.asset.HierarchicalElement;
import com.adobe.acs.commons.mcp.impl.processes.asset.Source;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class FileOrRendition
implements HierarchicalElement {
    final String url;
    final String name;
    final Folder folder;
    private Source fileSource;
    private final Map<String, FileOrRendition> additionalRenditions;
    String renditionName = null;
    String originalAssetName = null;
    Map<String, CompositeVariant> properties;
    ClientProvider clientProvider;

    public FileOrRendition(ClientProvider clientProvider, String name, String url, Folder folder, Map<String, CompositeVariant> data) {
        if (folder == null) {
            throw new NullPointerException("Folder cannot be null");
        }
        this.name = name;
        this.url = url;
        this.folder = folder;
        this.properties = new HashMap<String, CompositeVariant>(data);
        this.clientProvider = clientProvider;
        this.additionalRenditions = new TreeMap<String, FileOrRendition>();
    }

    public void setAsRenditionOfImage(String renditonName, String originalAssetName) {
        this.renditionName = renditonName;
        this.originalAssetName = originalAssetName;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    public boolean isRendition() {
        return this.renditionName != null && !this.renditionName.isEmpty();
    }

    public void addRendition(FileOrRendition rendition) {
        this.additionalRenditions.put(rendition.renditionName, rendition);
    }

    public Map<String, FileOrRendition> getRenditions() {
        return this.additionalRenditions;
    }

    public String getOriginalAssetName() {
        return this.originalAssetName;
    }

    @Override
    public HierarchicalElement getParent() {
        return this.folder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getItemName() {
        try {
            URI uri = new URI(HierarchicalElement.UriHelper.encodeUriParts(this.url));
            String filePath = HierarchicalElement.UriHelper.decodeUriParts(uri.getRawPath());
            return HierarchicalElement.UriHelper.decodeUriParts(filePath);
        }
        catch (UnsupportedEncodingException | URISyntaxException ex) {
            Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
            return this.url;
        }
    }

    @Override
    public Source getSource() {
        if (this.fileSource == null) {
            FileOrRendition thizz = this;
            this.fileSource = this.url.toLowerCase().startsWith("http") ? new HttpConnectionSource(thizz) : (this.url.toLowerCase().startsWith("sftp") ? new SftpConnectionSource(thizz) : new UrlConnectionSource(thizz));
        }
        return this.fileSource;
    }

    @Override
    public String getJcrBasePath() {
        return this.folder.getJcrBasePath();
    }

    @Override
    public String getSourcePath() {
        return this.url;
    }

    public Map<String, CompositeVariant> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public CompositeVariant getProperty(String prop) {
        return this.properties.get(prop);
    }

    @Override
    public Stream<HierarchicalElement> getChildren() {
        throw new UnsupportedOperationException("FileOrRendition doesn't support child navigation");
    }

    public class SftpConnectionSource
    implements Source {
        final FileOrRendition thizz;
        private final JSch jsch = new JSch();
        private Session session;
        private InputStream currentStream;
        private Channel channel;

        public SftpConnectionSource(FileOrRendition thizz) {
            this.thizz = thizz;
        }

        public Session getSessionForHost(URI uri) throws IOException {
            if (this.session != null && !this.session.getHost().equals(uri.getHost())) {
                this.close();
            }
            if (this.session == null || !this.session.isConnected()) {
                try {
                    int port = uri.getPort() <= 0 ? 22 : uri.getPort();
                    this.session = this.jsch.getSession(FileOrRendition.this.clientProvider.getUsername(), uri.getHost(), port);
                    this.session.setConfig("StrictHostKeyChecking", "no");
                    this.session.setPassword(FileOrRendition.this.clientProvider.getPassword());
                    this.session.connect();
                }
                catch (JSchException ex) {
                    Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException("Unable to connect to server", ex);
                }
            }
            return this.session;
        }

        @Override
        public String getName() {
            return FileOrRendition.this.name;
        }

        @Override
        public InputStream getStream() throws IOException {
            try {
                URI uri = new URI(HierarchicalElement.UriHelper.encodeUriParts(FileOrRendition.this.getSourcePath()));
                if (this.channel == null || this.channel.isClosed()) {
                    this.channel = this.getSessionForHost(uri).openChannel("sftp");
                    this.channel.connect();
                }
                ChannelSftp sftpChannel = (ChannelSftp)this.channel;
                this.currentStream = sftpChannel.get(HierarchicalElement.UriHelper.decodeUriParts(uri.getRawPath()));
                return this.currentStream;
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException("Bad URI format", ex);
            }
            catch (JSchException ex) {
                Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException("Error with connection", ex);
            }
            catch (SftpException ex) {
                Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException("Error retrieving file", ex);
            }
        }

        @Override
        public long getLength() throws IOException {
            try {
                URI uri = new URI(HierarchicalElement.UriHelper.encodeUriParts(FileOrRendition.this.getSourcePath()));
                if (this.channel == null || this.channel.isClosed()) {
                    this.channel = this.getSessionForHost(uri).openChannel("sftp");
                    this.channel.connect();
                }
                ChannelSftp sftpChannel = (ChannelSftp)this.channel;
                SftpATTRS stats = sftpChannel.lstat(HierarchicalElement.UriHelper.decodeUriParts(uri.getRawPath()));
                return stats.getSize();
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException("Error parsing URL", ex);
            }
            catch (SftpException ex) {
                Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException("Error getting file stats", ex);
            }
            catch (JSchException ex) {
                Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException("Error opening SFTP channel", ex);
            }
        }

        @Override
        public HierarchicalElement getElement() {
            return this.thizz;
        }

        @Override
        public void close() throws IOException {
            if (this.currentStream != null) {
                this.currentStream.close();
            }
            if (this.channel != null && this.channel.isConnected()) {
                this.channel.disconnect();
                this.channel = null;
            }
            if (this.session != null) {
                this.session.disconnect();
                this.session = null;
            }
        }
    }

    public class HttpConnectionSource
    implements Source {
        final FileOrRendition thizz;
        private HttpGet lastRequest;
        private Long size = null;
        private HttpResponse connection = null;

        public HttpConnectionSource(FileOrRendition thizz) {
            this.thizz = thizz;
        }

        @Override
        public String getName() {
            return FileOrRendition.this.name;
        }

        private HttpResponse initiateDownload() throws IOException {
            if (this.connection == null) {
                try {
                    this.lastRequest = new HttpGet(FileOrRendition.this.url);
                    this.connection = FileOrRendition.this.clientProvider.getHttpClientSupplier().get().execute((HttpUriRequest)this.lastRequest);
                    this.size = this.connection.getEntity().getContentLength();
                }
                catch (IOException | IllegalArgumentException ex) {
                    Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                    this.size = -1L;
                    throw new IOException("Error with URL " + FileOrRendition.this.url + ": " + ex.getMessage(), ex);
                }
            }
            return this.connection;
        }

        @Override
        public InputStream getStream() throws IOException {
            HttpResponse c = this.initiateDownload();
            return c.getEntity().getContent();
        }

        @Override
        public long getLength() throws IOException {
            if (this.size == null) {
                this.initiateDownload();
            }
            return this.size;
        }

        @Override
        public HierarchicalElement getElement() {
            return this.thizz;
        }

        @Override
        public void close() throws IOException {
            if (this.lastRequest != null) {
                this.lastRequest.releaseConnection();
                this.lastRequest = null;
            }
            if (this.connection != null && this.connection.getEntity() != null && this.connection.getEntity().getContent() != null) {
                this.connection.getEntity().getContent().close();
                this.connection = null;
            }
        }
    }

    public class UrlConnectionSource
    implements Source {
        final FileOrRendition thizz;
        private Long size = null;
        private URLConnection connection = null;
        private InputStream lastOpenStream = null;

        public UrlConnectionSource(FileOrRendition thizz) {
            this.thizz = thizz;
        }

        @Override
        public String getName() {
            return FileOrRendition.this.name;
        }

        private URLConnection getConnection() throws IOException {
            if (this.connection == null) {
                URL theUrl = new URL(FileOrRendition.this.url);
                this.connection = theUrl.openConnection();
            }
            return this.connection;
        }

        @Override
        public InputStream getStream() throws IOException {
            this.close();
            URLConnection c = this.getConnection();
            this.connection = null;
            return c.getInputStream();
        }

        @Override
        public long getLength() throws IOException {
            if (this.size == null) {
                try {
                    this.size = this.getConnection().getContentLengthLong();
                }
                catch (IOException ex) {
                    Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                    this.size = -1L;
                    throw ex;
                }
            }
            return this.size;
        }

        @Override
        public HierarchicalElement getElement() {
            return this.thizz;
        }

        @Override
        public void close() throws IOException {
            if (this.lastOpenStream != null) {
                this.lastOpenStream.close();
            }
            this.lastOpenStream = null;
        }
    }
}

