/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingException;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingNode;
import com.adobe.acs.commons.mcp.impl.processes.renovator.ReplicatorQueue;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MovingAsset
extends MovingNode {
    @Override
    public boolean isCopiedBeforeMove() {
        return false;
    }

    @Override
    public boolean isSupposedToBeReferenced() {
        return true;
    }

    @Override
    public boolean isAbleToHaveChildren() {
        return false;
    }

    @Override
    public void move(ReplicatorQueue replicatorQueue, ResourceResolver rr) throws IllegalAccessException, MovingException {
        Session session = (Session)rr.adaptTo(Session.class);
        try {
            session.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
            session.move(this.getSourcePath(), this.getDestinationPath());
            session.save();
            this.updateReferences(replicatorQueue, rr);
        }
        catch (RepositoryException e) {
            throw new MovingException(this.getSourcePath(), e);
        }
    }

    void updateReferences(ReplicatorQueue rep, ResourceResolver rr) {
        this.getAllReferences().forEach(ref -> this.updateReferences(rep, rr, (String)ref));
    }

    void updateReferences(ReplicatorQueue rep, ResourceResolver rr, String ref) {
        Resource res = rr.getResource(ref);
        ModifiableValueMap map = (ModifiableValueMap)res.adaptTo(ModifiableValueMap.class);
        AtomicBoolean changedProperty = new AtomicBoolean(false);
        map.forEach((key, val) -> {
            if (val != null && val.equals(this.getSourcePath())) {
                map.put(key, (Object)this.getDestinationPath());
                changedProperty.set(true);
            }
        });
        for (Resource child : res.getChildren()) {
            if (child.isResourceType("cq:Page")) continue;
            this.updateReferences(rep, rr, child.getPath());
        }
        try {
            if (changedProperty.get()) {
                rep.replicate(null, ReplicationActionType.ACTIVATE, ref);
            }
        }
        catch (ReplicationException ex) {
            Logger.getLogger(MovingAsset.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

