/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.ProcessDefinitionFactory;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.util.AnnotatedFieldDeserializer;
import com.adobe.cq.sightly.WCMUsePojo;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AvailableProcessDefinitions
extends WCMUsePojo {
    Map<String, ProcessDefinitionFactory> definitions = Collections.emptyMap();
    Map<String, FieldComponent> fieldComponents = Collections.emptyMap();

    public void activate() throws Exception {
        SlingScriptHelper sling = this.getSlingScriptHelper();
        User user = (User)sling.getRequest().getResourceResolver().adaptTo(User.class);
        ProcessDefinitionFactory[] allDefinitionFactories = (ProcessDefinitionFactory[])sling.getServices(ProcessDefinitionFactory.class, null);
        this.definitions = Stream.of(allDefinitionFactories).filter(o -> o.isAllowed(user)).collect(Collectors.toMap(ProcessDefinitionFactory::getName, o -> o, (a, b) -> a, TreeMap::new));
        String processDefinitionName = (String)this.get("processDefinition", String.class);
        if (StringUtils.isEmpty((String)processDefinitionName)) {
            processDefinitionName = this.getRequest().getParameter("processDefinition");
        }
        if (StringUtils.isNotEmpty((String)processDefinitionName) && this.definitions.containsKey(processDefinitionName)) {
            Class<?> clazz = this.definitions.get(processDefinitionName).createProcessDefinition().getClass();
            this.fieldComponents = AnnotatedFieldDeserializer.getFormFields(clazz, sling);
        }
    }

    public Map<String, ProcessDefinitionFactory> getDefinitions() {
        return this.definitions;
    }

    public Map<String, FieldComponent> getFieldComponents() {
        return this.fieldComponents;
    }
}

