/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrozenRendition
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FrozenRendition.class);
    private final Resource container;
    private final Resource renditionData;

    private FrozenRendition(Resource container) {
        this.container = container;
        this.renditionData = container.getChild("jcr:content");
    }

    public static Rendition createFrozenRendition(Asset asset, Resource resource) {
        FrozenRendition handler = new FrozenRendition(resource);
        return (Rendition)Proxy.newProxyInstance(FrozenRendition.class.getClassLoader(), new Class[]{Rendition.class}, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getSize": {
                return this.getSize();
            }
        }
        LOG.error("FROZEN RENDITION >> NO IMPLEMENTATION FOR " + methodName);
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        return this.container.getPath();
    }

    public long getSize() {
        int size = 0;
        Property p = (Property)this.renditionData.getValueMap().get("jcr:data", Property.class);
        try {
            return null != p ? p.getBinary().getSize() : 0L;
        }
        catch (RepositoryException e) {
            LOG.error("Failed to get the Rendition binary size in bytes [{}]: ", (Object)this.getPath(), (Object)e);
            return size;
        }
    }
}

