/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class IntrospectionUtil {
    public static boolean hasMultipleValues(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    public static Class<?> getCollectionComponentType(Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType t = (ParameterizedType)genericType;
                if (t.getActualTypeArguments().length == 1) {
                    return (Class)t.getActualTypeArguments()[0];
                }
                return null;
            }
            return Object.class;
        }
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        return field.getType();
    }

    public static boolean isPrimitive(Field field) {
        Class<?> basicType = IntrospectionUtil.getCollectionComponentType(field);
        return basicType != null && (basicType.isPrimitive() || Number.class.isAssignableFrom(basicType) || basicType == String.class);
    }

    public static boolean isSimple(Field field) {
        Class<?> basicType = IntrospectionUtil.getCollectionComponentType(field);
        return basicType != null && (IntrospectionUtil.isPrimitive(field) || basicType.isEnum() || basicType == String.class);
    }

    private IntrospectionUtil() {
    }
}

