/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.SharedValueMapValue;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.adobe.acs.commons.wcm.PageRootProvider;
import com.day.cq.wcm.api.Page;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;

@Component
@Service
@Property(name="service.ranking", intValue={4500})
public class SharedValueMapValueInjector
implements Injector {
    @Reference
    private PageRootProvider pageRootProvider;

    public String getName() {
        return "shared-component-properties-valuemap";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        Page pageRoot;
        if (element.getAnnotation(SharedValueMapValue.class) == null) {
            return null;
        }
        Resource resource = InjectorUtils.getResource(adaptable);
        if (resource != null && (pageRoot = this.pageRootProvider.getRootPage(resource)) != null) {
            ValueMap valueMap = null;
            switch (element.getAnnotation(SharedValueMapValue.class).type()) {
                case MERGED: {
                    valueMap = this.getMergedProperties(pageRoot, resource);
                    break;
                }
                case SHARED: {
                    valueMap = this.getSharedProperties(pageRoot, resource);
                    break;
                }
                case GLOBAL: {
                    valueMap = this.getGlobalProperties(pageRoot, resource);
                    break;
                }
            }
            if (valueMap != null) {
                return ReflectionUtil.convertValueMapValue(valueMap, name, declaredType);
            }
        }
        return null;
    }

    protected ValueMap getSharedProperties(Page pageRoot, Resource resource) {
        String sharedPropsPath = pageRoot.getPath() + "/" + "jcr:content" + "/" + "shared-component-properties" + "/" + resource.getResourceType();
        Resource sharedPropsResource = resource.getResourceResolver().getResource(sharedPropsPath);
        return sharedPropsResource != null ? sharedPropsResource.getValueMap() : ValueMapDecorator.EMPTY;
    }

    protected ValueMap getGlobalProperties(Page pageRoot, Resource resource) {
        String globalPropsPath = pageRoot.getPath() + "/" + "jcr:content" + "/" + "global-component-properties";
        Resource globalPropsResource = resource.getResourceResolver().getResource(globalPropsPath);
        return globalPropsResource != null ? globalPropsResource.getValueMap() : ValueMapDecorator.EMPTY;
    }

    protected ValueMap getMergedProperties(Page pageRoot, Resource resource) {
        HashMap mergedProperties = new HashMap();
        mergedProperties.putAll(this.getGlobalProperties(pageRoot, resource));
        mergedProperties.putAll(this.getSharedProperties(pageRoot, resource));
        mergedProperties.putAll(resource.getValueMap());
        return new ValueMapDecorator(mergedProperties);
    }

    protected void bindPageRootProvider(PageRootProvider pageRootProvider) {
        this.pageRootProvider = pageRootProvider;
    }

    protected void unbindPageRootProvider(PageRootProvider pageRootProvider) {
        if (this.pageRootProvider == pageRootProvider) {
            this.pageRootProvider = null;
        }
    }
}

