/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.day.cq.wcm.api.Page;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.util.DefaultProgressListener;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/instant-package"}, selectors={"package"}, extensions={"json"})
public class InstantPackageImpl
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(InstantPackageImpl.class);
    private static final String DEFAULT_PACKAGE_NAME = "instant-package-";
    private static final String DEFAULT_PACKAGE_GROUP_NAME = "Instant Package";
    private static final String DEFAULT_PACKAGE_VERSION = "1.0.0";
    private static final String DEFAULT_PACKAGE_DESCRIPTION = "Package has been created using ACS Commons Instant Package utility";
    private static final String JCR_CONTENT_APPEND = "/jcr:content";
    private static final String INSTANT_PACKAGE_THUMBNAIL_RESOURCE_PATH = "/apps/acs-commons/components/utilities/instant-package/thumbnail.png";
    @Reference
    private Packaging packaging;
    @Reference
    private PackageHelper packageHelper;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String paths = request.getParameter("pathList");
        String optionType = request.getParameter("optionType");
        if (StringUtils.isNotBlank((CharSequence)paths)) {
            try {
                List<Resource> packageResources = this.preparePackageResources(paths, optionType, resourceResolver);
                HashMap<String, String> packageDefinitionProperties = new HashMap<String, String>();
                packageDefinitionProperties.put("jcr:description", DEFAULT_PACKAGE_DESCRIPTION);
                if (packageResources.isEmpty()) {
                    response.getWriter().print(this.packageHelper.getErrorJSON("Refusing to create a package with no filter set rules."));
                } else {
                    JcrPackage jcrPackage = this.packageHelper.createPackage(packageResources, (Session)request.getResourceResolver().adaptTo(Session.class), DEFAULT_PACKAGE_GROUP_NAME, DEFAULT_PACKAGE_NAME + new Date().getTime(), DEFAULT_PACKAGE_VERSION, PackageHelper.ConflictResolution.valueOf(PackageHelper.ConflictResolution.IncrementVersion.toString()), packageDefinitionProperties);
                    this.packageHelper.addThumbnail(jcrPackage, request.getResourceResolver().getResource(INSTANT_PACKAGE_THUMBNAIL_RESOURCE_PATH));
                    DefaultProgressListener listener = new DefaultProgressListener();
                    JcrPackageManager jcrPackageManager = this.packaging.getPackageManager((Session)resourceResolver.adaptTo(Session.class));
                    jcrPackageManager.assemble(jcrPackage, (ProgressTrackerListener)listener);
                    log.debug("Successfully created and build JCR package");
                    response.getWriter().print(this.packageHelper.getSuccessJSON(jcrPackage));
                }
            }
            catch (PackageException ex) {
                log.error("Package Exception error while creating Instant Package", (Throwable)ex);
                response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
            }
            catch (RepositoryException ex) {
                log.error("Repository error while creating Instant Package", (Throwable)ex);
                response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
            }
            catch (IOException ex) {
                log.error("IO error while creating Instant Package", (Throwable)ex);
                response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
            }
        }
    }

    private List<Resource> preparePackageResources(String paths, String optionType, ResourceResolver resourceResolver) {
        String[] pathList = paths.split(",");
        ArrayList<Resource> allPaths = new ArrayList<Resource>();
        ArrayList<Resource> packageResources = "selectedResource".equals(optionType) ? this.getSelectedPath(resourceResolver, pathList, allPaths) : ("immediateChildren".equals(optionType) ? this.getImmediateChildren(resourceResolver, pathList, allPaths) : this.getAllChildren(resourceResolver, pathList, allPaths));
        return packageResources;
    }

    private ArrayList<Resource> getImmediateChildren(ResourceResolver resourceResolver, String[] pathList, ArrayList<Resource> allPaths) {
        for (String path : pathList) {
            Resource currentPath = resourceResolver.getResource(path);
            if (path.startsWith("/content/dam")) {
                Iterator childAssetRes = currentPath.listChildren();
                this.getImmediateAssets(resourceResolver, childAssetRes, allPaths);
                continue;
            }
            Iterator childPageRes = ((Page)currentPath.adaptTo(Page.class)).listChildren();
            this.getImmediatePages(resourceResolver, currentPath, childPageRes, allPaths);
        }
        return allPaths;
    }

    private ArrayList<Resource> getImmediatePages(ResourceResolver resourceResolver, Resource pagePath, Iterator<Page> childPageRes, ArrayList<Resource> allPaths) {
        allPaths.add(resourceResolver.getResource(pagePath.getPath() + JCR_CONTENT_APPEND));
        while (childPageRes.hasNext()) {
            Resource res = resourceResolver.getResource(childPageRes.next().getPath() + JCR_CONTENT_APPEND);
            if (!"cq:PageContent".equals(res.getValueMap().get("jcr:primaryType", String.class))) continue;
            allPaths.add(res);
        }
        return allPaths;
    }

    private ArrayList<Resource> getImmediateAssets(ResourceResolver resourceResolver, Iterator<Resource> childRes, ArrayList<Resource> allPaths) {
        while (childRes.hasNext()) {
            Resource res = resourceResolver.getResource(childRes.next().getPath());
            if (!"dam:Asset".equals(res.getValueMap().get("jcr:primaryType", String.class))) continue;
            allPaths.add(res);
        }
        return allPaths;
    }

    private ArrayList<Resource> getSelectedPath(ResourceResolver resourceResolver, String[] pathList, ArrayList<Resource> allPaths) {
        for (String path : pathList) {
            Resource currentPath = resourceResolver.getResource(path);
            allPaths.add(resourceResolver.getResource(currentPath.getPath() + JCR_CONTENT_APPEND));
        }
        return allPaths;
    }

    private ArrayList<Resource> getAllChildren(ResourceResolver resourceResolver, String[] pathList, ArrayList<Resource> allPaths) {
        for (String path : pathList) {
            Resource currentPath = resourceResolver.getResource(path);
            allPaths.add(resourceResolver.getResource(currentPath.getPath()));
        }
        return allPaths;
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }
}

