/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.remoteassets.impl;

import com.adobe.acs.commons.remoteassets.RemoteAssetsBinarySync;
import com.adobe.acs.commons.remoteassets.RemoteAssetsConfig;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RemoteAssetsBinarySync.class})
public class RemoteAssetsBinarySyncImpl
implements RemoteAssetsBinarySync {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAssetsBinarySyncImpl.class);
    @Reference
    private RemoteAssetsConfig remoteAssetsConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncAsset(Resource resource) {
        ResourceResolver remoteAssetsResolver = null;
        try {
            remoteAssetsResolver = this.remoteAssetsConfig.getResourceResolver();
            Resource localRes = remoteAssetsResolver.getResource(resource.getPath());
            Asset asset = DamUtil.resolveToAsset((Resource)localRes);
            URI pathUri = new URI(null, null, asset.getPath(), null);
            String baseUrl = this.remoteAssetsConfig.getServer().concat(pathUri.toString()).concat("/_jcr_content/renditions/");
            Iterator renditions = asset.listRenditions();
            while (renditions.hasNext()) {
                Rendition assetRendition = (Rendition)renditions.next();
                if (StringUtils.isEmpty((CharSequence)assetRendition.getMimeType())) continue;
                String renditionName = assetRendition.getName();
                String remoteUrl = String.format("%s%s", baseUrl, renditionName);
                this.setRenditionOnAsset(remoteUrl, assetRendition, asset, renditionName);
            }
            ModifiableValueMap localResProps = (ModifiableValueMap)localRes.adaptTo(ModifiableValueMap.class);
            localResProps.remove((Object)"isRemoteAsset");
            localResProps.remove((Object)"remoteSyncFailed");
            remoteAssetsResolver.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Error transferring remote asset '{}' to local server", (Object)resource.getPath(), (Object)e);
            try {
                if (remoteAssetsResolver != null) {
                    remoteAssetsResolver.revert();
                }
            }
            catch (Exception re) {
                LOG.error("Failed to rollback asset changes", (Throwable)re);
            }
            this.flagAssetAsFailedSync(remoteAssetsResolver, resource);
        }
        finally {
            this.remoteAssetsConfig.closeResourceResolver(remoteAssetsResolver);
        }
        return false;
    }

    private void setRenditionOnAsset(String remoteUrl, Rendition assetRendition, Asset asset, String renditionName) throws IOException {
        LOG.debug("Syncing from remote asset url: {}", (Object)remoteUrl);
        Executor executor = this.remoteAssetsConfig.getRemoteAssetsHttpExecutor();
        try (InputStream inputStream = executor.execute(Request.Get((String)remoteUrl)).returnContent().asStream();){
            asset.addRendition(renditionName, inputStream, assetRendition.getMimeType());
        }
        catch (HttpResponseException fne) {
            if ("original".equals(renditionName) || fne.getStatusCode() != 404) {
                throw fne;
            }
            asset.removeRendition(renditionName);
            LOG.warn("Rendition '{}' not found on remote environment. Removing local rendition.", (Object)renditionName);
        }
    }

    private void flagAssetAsFailedSync(ResourceResolver remoteAssetsResolver, Resource resource) {
        try {
            Resource localRes = remoteAssetsResolver.getResource(resource.getPath());
            ModifiableValueMap localResProps = (ModifiableValueMap)localRes.adaptTo(ModifiableValueMap.class);
            localResProps.put((Object)"remoteSyncFailed", (Object)Calendar.getInstance());
            remoteAssetsResolver.commit();
        }
        catch (Exception e) {
            LOG.error("Error flagging remote asset '{}' as failed - asset may attempt to sync numerous times in succession", (Object)resource.getPath(), (Object)e);
            try {
                remoteAssetsResolver.revert();
            }
            catch (Exception re) {
                LOG.error("Failed to rollback asset changes", (Throwable)re);
            }
        }
    }
}

