/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportExecutor;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ReportRunner {
    private static final Logger log = LoggerFactory.getLogger(ReportRunner.class);
    public static final String PN_EXECUTOR = "reportExecutor";
    private String failureMessage;
    private int page;
    private ReportExecutor reportExecutor;
    private SlingHttpServletRequest request;
    private boolean succeeded = true;
    @OSGiService
    private DynamicClassLoaderManager dynamicClassLoaderManager;

    public ReportRunner(SlingHttpServletRequest request) {
        this.request = request;
    }

    ReportRunner(SlingHttpServletRequest request, DynamicClassLoaderManager dynamicClassLoaderManager) {
        this(request);
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    private boolean executeConfig(Resource config, SlingHttpServletRequest request) {
        log.trace("executeConfig");
        String reportExecutorClass = (String)config.getValueMap().get(PN_EXECUTOR, String.class);
        if (StringUtils.isNotBlank((String)reportExecutorClass)) {
            log.debug("Loading class for: {}", (Object)reportExecutorClass);
            try {
                Class<?> exClass = Class.forName(reportExecutorClass, true, this.dynamicClassLoaderManager.getDynamicClassLoader());
                Object model = request.adaptTo(exClass);
                if (model instanceof ReportExecutor) {
                    ReportExecutor ex = (ReportExecutor)model;
                    ex.setConfiguration(config);
                    ex.setPage(this.page);
                    this.reportExecutor = ex;
                    return true;
                }
                log.warn("Class {} is not an instance of ReportExecutor", (Object)this.reportExecutor);
            }
            catch (ClassNotFoundException e) {
                log.warn("Unable to find class for " + this.reportExecutor, (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Unexpected exception executing report executor " + this.reportExecutor, (Throwable)e);
            }
        } else {
            log.warn("No executor found for {}", (Object)config);
        }
        return false;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public ReportExecutor getReportExecutor() {
        return this.reportExecutor;
    }

    @PostConstruct
    protected void init() {
        log.trace("init");
        try {
            this.page = Integer.parseInt(this.request.getParameter("page"), 10);
        }
        catch (Exception e) {
            this.page = 0;
        }
        Resource configCtr = this.request.getResource().getChild("config");
        boolean resultsRetrieved = false;
        if (configCtr != null && configCtr.listChildren().hasNext()) {
            Iterator children = configCtr.listChildren();
            while (children.hasNext()) {
                Resource config = (Resource)children.next();
                if (this.executeConfig(config, this.request)) {
                    log.debug("Successfully executed report with configuration: {}", (Object)config);
                    resultsRetrieved = true;
                    break;
                }
                log.warn("Unable to execute report for configuration: {}", (Object)config);
            }
        } else {
            log.warn("No configurations found for {}", (Object)this.request.getResource());
            this.succeeded = false;
            this.failureMessage = "No configurations found!";
            return;
        }
        if (!resultsRetrieved) {
            log.warn("No results were retrieved for {}", (Object)this.request.getResource());
            this.succeeded = false;
            this.failureMessage = "No results retrieved!";
        }
    }

    public boolean isSuccessful() {
        return this.succeeded;
    }
}

