/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.ContentHandlerBasedTransformer;
import com.adobe.acs.commons.rewriter.DelegatingTransformer;
import com.adobe.acs.commons.rewriter.impl.SaxElementUtils;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(metatype=false, label="Stylesheet Inliner Transformer Factory", description="Sling Rewriter Transformer Factory which inlines CSS references")
@Properties(value={@Property(name="pipeline.type", value={"inline-css"}, propertyPrivate=true)})
@Service(value={TransformerFactory.class})
public final class StylesheetInlinerTransformerFactory
implements TransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(StylesheetInlinerTransformerFactory.class);
    private static final char[] NEWLINE = new char[]{'\n'};
    @Reference
    private HtmlLibraryManager htmlLibraryManager;

    public Transformer createTransformer() {
        return new SelectorAwareCssInlinerTransformer();
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    final class SelectorAwareCssInlinerTransformer
    extends DelegatingTransformer {
        SelectorAwareCssInlinerTransformer() {
        }

        @Override
        public void init(ProcessingContext context, ProcessingComponentConfiguration componentConfiguration) throws IOException {
            SlingHttpServletRequest request = context.getRequest();
            boolean inlineCss = false;
            String[] selectors = request.getRequestPathInfo().getSelectors();
            for (int i = 0; !inlineCss && i < selectors.length; ++i) {
                inlineCss = "inline-css".equals(selectors[i]);
            }
            if (inlineCss) {
                this.setDelegate(new CssInlinerTransformer());
            } else {
                this.setDelegate(new ContentHandlerBasedTransformer());
            }
            super.init(context, componentConfiguration);
        }
    }

    private final class CssInlinerTransformer
    extends ContentHandlerBasedTransformer {
        private static final String HEAD = "head";
        private static final String STYLE = "style";
        private final Attributes attrs = new AttributesImpl();
        private final Map<String, char[]> stylesheetsInHead = new LinkedHashMap<String, char[]>();
        private SlingHttpServletRequest slingRequest;
        private boolean afterHeadElement = false;

        private CssInlinerTransformer() {
        }

        @Override
        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
            super.init(context, config);
            this.slingRequest = context.getRequest();
            log.debug("Inlining Stylesheet references for {}", (Object)this.slingRequest.getRequestURL().toString());
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            try {
                ContentHandler contentHandler = this.getContentHandler();
                if (SaxElementUtils.isCss(localName, attrs)) {
                    String sheet = attrs.getValue("", "href");
                    if (this.afterHeadElement) {
                        log.debug("Inlining stylesheet link found in BODY: '{}'", (Object)sheet);
                        if (!this.inlineSheet(namespaceURI, sheet)) {
                            contentHandler.startElement(namespaceURI, localName, qName, attrs);
                        }
                    } else {
                        Optional<char[]> contents = this.readSheetContent(sheet);
                        if (contents.isPresent()) {
                            this.stylesheetsInHead.put(sheet, contents.get());
                        } else {
                            contentHandler.startElement(namespaceURI, localName, qName, attrs);
                        }
                    }
                } else {
                    contentHandler.startElement(namespaceURI, localName, qName, attrs);
                }
            }
            catch (IOException | SAXException e) {
                log.error("Exception in stylesheet inliner", (Throwable)e);
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (HEAD.equalsIgnoreCase(localName)) {
                this.afterHeadElement = true;
                try {
                    for (Map.Entry<String, char[]> entry : this.stylesheetsInHead.entrySet()) {
                        log.debug("Inlining sheet found in HEAD: '{}'", (Object)entry.getKey());
                        this.inlineSheet(uri, entry.getValue());
                    }
                }
                catch (SAXException e) {
                    log.error("Exception in stylesheet inliner", (Throwable)e);
                    throw new SAXException(e);
                }
            }
            this.getContentHandler().endElement(uri, localName, qName);
        }

        private Optional<char[]> readSheetContent(String sheet) throws IOException, SAXException {
            InputStream inputStream = null;
            String withoutExtension = sheet.substring(0, sheet.indexOf(LibraryType.CSS.extension));
            HtmlLibrary library = StylesheetInlinerTransformerFactory.this.htmlLibraryManager.getLibrary(LibraryType.CSS, withoutExtension);
            if (library != null) {
                inputStream = library.getInputStream();
            } else {
                Resource resource = this.slingRequest.getResourceResolver().getResource(sheet);
                if (resource != null) {
                    inputStream = (InputStream)resource.adaptTo(InputStream.class);
                }
            }
            if (inputStream != null) {
                return Optional.of(IOUtils.toCharArray((InputStream)inputStream, (String)"UTF-8"));
            }
            return Optional.empty();
        }

        private boolean inlineSheet(String namespaceURI, char[] content) throws SAXException {
            if (content != null) {
                ContentHandler contentHandler = this.getContentHandler();
                contentHandler.startElement(namespaceURI, STYLE, null, this.attrs);
                contentHandler.characters(NEWLINE, 0, 1);
                contentHandler.characters(content, 0, content.length);
                contentHandler.endElement(namespaceURI, STYLE, null);
                return true;
            }
            return false;
        }

        private boolean inlineSheet(String namespaceURI, String sheet) throws IOException, SAXException {
            return this.inlineSheet(namespaceURI, (char[])this.readSheetContent(sheet).orElse(null));
        }
    }
}

