/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.synth.children.impl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSONModifiableValueMapDecorator
extends ModifiableValueMapDecorator {
    private static final Logger log = LoggerFactory.getLogger(JSONModifiableValueMapDecorator.class);

    public JSONModifiableValueMapDecorator() {
        super(new HashMap());
    }

    public JSONModifiableValueMapDecorator(Map<String, Object> base) {
        super(base);
    }

    public <T> T get(String name, Class<T> type) {
        try {
            if (Calendar.class.equals(type)) {
                return (T)this.getCalendar(name);
            }
            if (Date.class.equals(type)) {
                return (T)this.getDate(name);
            }
            if (BigDecimal.class.equals(type)) {
                return (T)this.getBigDecimal(name);
            }
            if (Integer.class.equals(type)) {
                return (T)this.getInteger(name);
            }
            return (T)super.get(name, type);
        }
        catch (Exception e) {
            log.warn("Unable to get property [ {} ] as [ {} ]. Returning null.", (Object)name, type);
            return null;
        }
    }

    public <T> T get(String name, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> type = defaultValue.getClass();
        Class<Object> value = this.get(name, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    private Calendar getCalendar(String name) {
        Object obj = super.get((Object)name);
        if (obj instanceof Calendar) {
            return (Calendar)obj;
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            return cal;
        }
        String tmp = (String)super.get(name, String.class);
        DateTime dateTime = ISODateTimeFormat.dateTime().parseDateTime(tmp);
        if (dateTime != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateTime.toDate());
            return cal;
        }
        return null;
    }

    private Date getDate(String name) {
        Object obj = super.get((Object)name);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return cal.getTime();
        }
        String tmp = (String)super.get(name, String.class);
        DateTime dateTime = ISODateTimeFormat.dateTime().parseDateTime(tmp);
        if (dateTime != null) {
            return dateTime.toDate();
        }
        return null;
    }

    private Integer getInteger(String name) {
        Object obj = super.get((Object)name);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Double) {
            Double tmp = (Double)obj;
            return tmp.intValue();
        }
        if (obj instanceof Long) {
            Long tmp = (Long)obj;
            return tmp.intValue();
        }
        String tmp = (String)super.get(name, String.class);
        return Integer.parseInt(tmp);
    }

    private BigDecimal getBigDecimal(String name) {
        Object obj = super.get((Object)name);
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj instanceof Long) {
            return BigDecimal.valueOf((Long)obj);
        }
        if (obj instanceof Integer) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
        String tmp = (String)super.get(name, String.class);
        return new BigDecimal(tmp);
    }
}

