/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.model;

import acscommons.com.google.common.annotations.VisibleForTesting;
import acscommons.com.google.common.base.Strings;
import acscommons.com.google.common.collect.Lists;
import com.adobe.acs.commons.wcm.comparisons.PageCompareData;
import com.adobe.acs.commons.wcm.comparisons.PageCompareDataLine;
import com.adobe.acs.commons.wcm.comparisons.PageCompareDataLines;
import com.adobe.acs.commons.wcm.comparisons.PageCompareDataLoader;
import com.adobe.acs.commons.wcm.comparisons.VersionService;
import com.adobe.acs.commons.wcm.comparisons.lines.Line;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class PageCompareModel {
    private static final Logger log = LoggerFactory.getLogger(PageCompareModel.class);
    public static final String LATEST = "latest";
    private final String pathA;
    private String versionA;
    private final String pathB;
    private String versionB;
    @Inject
    @VisibleForTesting
    ResourceResolver resolver;
    @Inject
    @VisibleForTesting
    PageCompareDataLoader loader;
    @Inject
    @VisibleForTesting
    PageCompareDataLines lines;
    @Inject
    @VisibleForTesting
    VersionService versionService;
    private PageCompareData a;
    private PageCompareData b;

    public PageCompareModel(SlingHttpServletRequest request) {
        this.pathA = request.getParameter("path");
        String paramVersionA = request.getParameter("a");
        this.pathB = request.getParameter("pathB");
        String paramVersionB = request.getParameter("b");
        this.versionA = Strings.isNullOrEmpty(paramVersionA) ? LATEST : paramVersionA;
        this.versionB = Strings.isNullOrEmpty(paramVersionB) ? LATEST : paramVersionB;
    }

    @PostConstruct
    public void activate() {
        if (this.pathA == null) {
            return;
        }
        Resource resource = this.resolver.resolve(this.pathA);
        this.improveDefaultVersionCompare(resource);
        this.a = this.load(resource, this.versionA);
        Resource resourceB = this.pathB != null ? this.resolver.resolve(this.pathB) : resource;
        this.b = this.load(resourceB, this.versionB);
    }

    private void improveDefaultVersionCompare(Resource resource) {
        if (!this.versionA.equals(LATEST) || !this.versionA.equals(this.versionB) || this.pathB != null && !this.pathA.equals(this.pathB)) {
            return;
        }
        Version version = this.versionService.lastVersion(resource);
        if (version != null) {
            try {
                this.versionA = version.getName();
            }
            catch (RepositoryException e) {
                log.error("error getting version name", (Throwable)e);
            }
        }
    }

    public List<Line<PageCompareDataLine>> getData() {
        if (this.a != null && this.b != null) {
            return this.lines.generate(this.a.getLines(), this.b.getLines());
        }
        return Lists.newArrayList();
    }

    public PageCompareData getA() {
        return this.a;
    }

    public PageCompareData getB() {
        return this.b;
    }

    public String getPathA() {
        return this.pathA;
    }

    public String getVersionA() {
        return this.versionA;
    }

    public String getPathB() {
        return this.pathB;
    }

    public String getVersionB() {
        return this.versionB;
    }

    private PageCompareData load(Resource resource, String version) {
        if (resource != null && !ResourceUtil.isNonExistingResource((Resource)resource)) {
            try {
                return this.loader.load(resource, version);
            }
            catch (RepositoryException e) {
                log.error("Error loading data", (Throwable)e);
            }
        }
        return null;
    }
}

