/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl.servlets;

import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalStatus;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/workflow-remover"}, selectors={"force-quit"}, extensions={"json"})
public class ForceQuitServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ForceQuitServlet.class);
    @Reference
    private WorkflowInstanceRemover workflowInstanceRemover;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            this.workflowInstanceRemover.forceQuit();
            if (this.workflowInstanceRemover.getStatus() != null) {
                response.getWriter().write(this.workflowInstanceRemover.getStatus().getJSON().toString());
            } else {
                WorkflowRemovalStatus workflowStatus = new WorkflowRemovalStatus(request.getResourceResolver());
                workflowStatus.setRunning(false);
                response.getWriter().write(workflowStatus.getJSON().toString());
            }
        }
        catch (Exception e) {
            log.error("Unable to create Workflow Removal status after Force Quit", (Throwable)e);
            response.setStatus(500);
            response.getWriter().write(e.getMessage());
        }
    }

    protected void bindWorkflowInstanceRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        this.workflowInstanceRemover = workflowInstanceRemover;
    }

    protected void unbindWorkflowInstanceRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        if (this.workflowInstanceRemover == workflowInstanceRemover) {
            this.workflowInstanceRemover = null;
        }
    }
}

